<?php
session_start();

if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    header('Location: login.php');
    exit;
}
?>
<!doctype html>
<html lang="fr">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex, nofollow, noimageindex, noarchive, nocache, nosnippet">
    <title>🥷 Corleone Control Panel 🥷</title>
    <style>
        /* Général */
        body {
            background-color: #121212;
            color: #c5c6c7;
            font-family: 'Roboto Mono', monospace;
            margin: 0;
            padding: 0;
        }

        h1,
        h2 {
            color: #39ff14;
        }

        .container-fluid {
            margin: 20px auto;
            padding: 20px;
            max-width: 90%;
        }

        /* Table */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            padding: 15px;
            text-align: center;
            border: 1px solid #333;
        }

        th {
            background-color: #2e2e2e;
            color: #39ff14;
            font-weight: bold;
            font-size: 1rem;
        }

        td {
            background-color: #1e1e1e;
            color: #c5c6c7;
        }

        tr:nth-child(even) {
            background-color: #2a2a2a;
        }

        tr:hover {
            background-color: #444;
        }

        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
            background-color: #101010;
            border-bottom: 1px solid #333;
        }

        .header h1 {
            font-size: 1.8rem;
            margin: 0;
        }

        .header .status {
            font-size: 1.1rem;
            color: #ff6666;
        }

        /* Formulaire */
        .form-container {
            background-color: #1e1e1e;
            padding: 20px;
            border: 1px solid #333;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
        }

        .form-container input[type="text"] {
            flex: 1;
            margin-right: 10px;
            padding: 10px;
            font-size: 1rem;
            border: 1px solid #333;
            background-color: #121212;
            color: #39ff14;
            border-radius: 5px;
        }

        .form-container input[type="text"]::placeholder {
            color: #555;
        }

        .form-container .btn {
            padding: 10px 20px;
            font-size: 1rem;
            color: #39ff14;
            background-color: #111;
            border: 2px solid #39ff14;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .form-container .btn:hover {
            background-color: #39ff14;
            color: #111;
        }

        /* Boutons d'action */
        .buttons {
            display: flex;
            justify-content: space-evenly;
            gap: 20px;
            margin-top: 20px;
        }

        .buttons .btn {
            padding: 15px 30px;
            font-size: 1rem;
            color: #39ff14;
            background-color: #111;
            border: 2px solid #39ff14;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .buttons .btn:hover {
            background-color: #39ff14;
            color: #111;
        }

        /* Boutons en rouge pour Ban et Clear Logs */
        .buttons .btn-danger {
            color: #ff4d4d;
            border-color: #ff4d4d;
        }

        .buttons .btn-danger:hover {
            background-color: #ff4d4d;
            color: #fff;
        }

        /* Notifications */
        .notifications {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .notification {
            background-color: #1e1e1e;
            color: #39ff14;
            padding: 15px 20px;
            border-left: 5px solid #39ff14;
            border-radius: 5px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.5);
            font-size: 0.9rem;
            animation: slideIn 0.5s ease-out, fadeOut 5s ease forwards;
        }

        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }

            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        @keyframes fadeOut {
            0% {
                opacity: 1;
            }

            80% {
                opacity: 1;
            }

            100% {
                opacity: 0;
            }
        }

        /* CAPTCHA */
        .captcha {
            margin-top: 20px;
            padding: 15px;
            text-align: center;
            border: 2px dashed #39ff14;
            color: #39ff14;
            background-color: #121212;
            border-radius: 10px;
        }

        /* Footer */
        footer {
            text-align: center;
            color: #aaa;
            padding: 15px;
            background-color: #101010;
            font-size: 0.9rem;
        }

        /* Switch style */
        .switch-container {
            display: flex;
            align-items: center;
            margin-top: 20px;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 24px;
            margin-right: 10px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: 0.4s;
            border-radius: 24px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            transition: 0.4s;
            border-radius: 50%;
        }

input:checked + .slider {
    background-color: #ff0000;
}

        input:checked+.slider:before {
            transform: translateX(26px);
        }


        .form-container p {
            font-size: 1rem;
            color: #39ff14;
            margin: 0;
            margin-bottom: 10px;
            font-weight: bold;
            text-align: center;
            width: 100%;
        }

    
        .form-container .captcha-message {
            font-size: 1rem;
            color: #c5c6c7;
            margin-bottom: 10px;
            text-align: center;
        }

        /* Container du bouton More Infos */
        .more-info-container {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            margin-bottom: 10px;
        }

        .more-info-btn {
            padding: 10px 20px;
            font-size: 1rem;
            color: #39ff14;
            background-color: #111;
            border: 2px solid #39ff14;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
            border-radius: 5px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.5);
            position: relative;
            left: 54vh;
        }

        .more-info-btn:hover {
            background-color: #39ff14;
            color: #111;
            box-shadow: 0 6px 10px rgba(0, 255, 20, 0.5);
        }
        /* Effet Matrix en arrière-plan */
body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    z-index: -1;
    opacity: 0.1;
    background: linear-gradient(rgba(0, 255, 20, 0.1) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0, 255, 20, 0.1) 1px, transparent 1px);
    background-size: 20px 20px;
    animation: matrix 20s linear infinite;
}

@keyframes matrix {
    0% { background-position: 0 0; }
    100% { background-position: 40px 40px; }
}


@keyframes scan {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(1500px); }
}

/* Effet de glitch sur le titre */
.header h1 {
    position: relative;
    text-shadow: 
        0.05em 0 0 rgba(255, 0, 0, 0.75),
        -0.025em -0.05em 0 rgba(0, 255, 0, 0.75),
        0.025em 0.05em 0 rgba(0, 0, 255, 0.75);
    animation: glitch 500ms infinite;
}

@keyframes glitch {
    0% { text-shadow: 0.05em 0 0 rgba(255, 0, 0, 0.75),
        -0.05em -0.025em 0 rgba(0, 255, 0, 0.75),
        -0.025em 0.05em 0 rgba(0, 0, 255, 0.75); }
    15% { text-shadow: -0.05em -0.025em 0 rgba(255, 0, 0, 0.75),
        0.025em 0.025em 0 rgba(0, 255, 0, 0.75),
        -0.05em -0.05em 0 rgba(0, 0, 255, 0.75); }
    50% { text-shadow: 0.025em 0.05em 0 rgba(255, 0, 0, 0.75),
        0.05em 0 0 rgba(0, 255, 0, 0.75),
        0 -0.05em 0 rgba(0, 0, 255, 0.75); }
}


.btn {
    position: relative;
    overflow: hidden;
    box-shadow: 0 0 10px rgba(57, 255, 20, 0.3);
}

.btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(
        90deg,
        transparent,
        rgba(57, 255, 20, 0.2),
        transparent
    );
    animation: btnScan 3s linear infinite;
}

@keyframes btnScan {
    0% { left: -100%; }
    100% { left: 200%; }
}

/* Effet sur le tableau */
table {
    position: relative;
    box-shadow: 0 0 20px rgba(57, 255, 20, 0.1);
}

tr {
    position: relative;
    transition: all 0.3s ease;
}

tr:hover {
    background-color: rgba(57, 255, 20, 0.1) !important;
    transform: scale(1.01);
}


.notification {
    border-left: 5px solid #39ff14;
    background: rgba(0, 0, 0, 0.9);
    backdrop-filter: blur(10px);
    box-shadow: 0 0 15px rgba(57, 255, 20, 0.3);
    animation: notificationGlow 2s infinite alternate;
}

@keyframes notificationGlow {
    from { box-shadow: 0 0 15px rgba(57, 255, 20, 0.3); }
    to { box-shadow: 0 0 25px rgba(57, 255, 20, 0.5); }
}

/* Effet de terminal pour les inputs */
input[type="text"] {
    background: rgba(0, 0, 0, 0.8);
    border: 1px solid #39ff14;
    color: #39ff14;
    text-shadow: 0 0 5px rgba(57, 255, 20, 0.5);
    caret-color: #39ff14;
}

input[type="text"]:focus {
    outline: none;
    box-shadow: 0 0 15px rgba(57, 255, 20, 0.3);
    animation: inputPulse 1.5s infinite;
}

@keyframes inputPulse {
    0% { box-shadow: 0 0 15px rgba(57, 255, 20, 0.3); }
    50% { box-shadow: 0 0 25px rgba(57, 255, 20, 0.5); }
    100% { box-shadow: 0 0 15px rgba(57, 255, 20, 0.3); }
}
/* Dans votre balise <style> */
body {
    background-color: #000000 !important; /* Fond noir */
    position: relative;
    overflow-x: hidden;
}

/* Effet Matrix en rouge */
.matrix-background {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: -1;
}

/* Modifiez les couleurs en rouge */
.status-indicator, .btn, input[type="text"], h1, h2 {
    color: #ff0000 !important;
    border-color: #ff0000 !important;
}

.btn:hover {
    background-color: #ff0000 !important;
    color: #000 !important;
}

input[type="text"] {
    text-shadow: 0 0 5px rgba(255, 0, 0, 0.5) !important;
}

.notification {
    border-left: 5px solid #ff0000 !important;
    box-shadow: 0 0 15px rgba(255, 0, 0, 0.3) !important;
}
/* ... existing code ... */

.allowed-countries-input {
    margin-top: 20px;
    display: flex;
    gap: 10px;
    width: 100%;
}
/* ... existing code ... */

/* Formulaire */
.form-container {
    background-color: #1e1e1e;
    padding: 20px;
    border: 1px solid #333;
    border-radius: 10px;
    margin-bottom: 20px;
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
    align-items: center;
}

/* Ajoutez les nouvelles règles ici, juste après le .form-container */
/* Nouveau style pour le conteneur de l'IP */
.form-container > input[type="text"]#ipAddress {
    width: 50%;
    flex: initial;
    margin-right: 10px;
}

/* Ajustement pour le bouton Set IP */
.form-container > button.btn:first-of-type {
    width: auto;
}

/* Style pour le groupe IP + bouton */
.form-container > input[type="text"]#ipAddress,
.form-container > button.btn:first-of-type {
    display: inline-block;
    vertical-align: middle;
}

/* Responsive */
@media screen and (max-width: 768px) {
    .form-container > input[type="text"]#ipAddress {
        width: 70%;
    }
}

@media screen and (max-width: 480px) {
    .form-container > input[type="text"]#ipAddress {
        width: 100%;
    }
}

/* Continuez avec les autres styles existants */
.form-container input[type="text"] {
    flex: 1;
    margin-right: 10px;
    padding: 10px;
    font-size: 1rem;
    border: 1px solid #333;
    background-color: #121212;
    color: #39ff14;
    border-radius: 5px;
}
/* ... rest of your existing code ... */

.country-tag {
    background: rgba(0, 0, 0, 0.8);
    border: 1px solid #ff0000;
    color: #ff0000;
    padding: 5px 10px;
    border-radius: 5px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.country-tag .remove {
    cursor: pointer;
    font-size: 14px;
    padding: 0 5px;
}

.country-tag .remove:hover {
    color: white;
}
/* Style pour le bouton Show Options */
.show-options-btn {
    margin-bottom: 20px;
    background-color: #1e1e1e;
    border: 1px solid #ff0000;
    color: #ff0000;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.show-options-btn:hover {
    background-color: #ff0000;
    color: #000;
}

/* Styles pour l'animation du formulaire */
.form-container {
    transition: all 0.5s ease;
    max-height: 1000px; /* Ajustez selon la hauteur maximale de votre formulaire */
    opacity: 1;
    transform: translateY(0);
    overflow: hidden;
}

.form-container.hidden {
    max-height: 0;
    opacity: 0;
    transform: translateY(-20px);
    margin: 0;
    padding: 0;
    border: none;
}

@import url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css');

/* Style pour le bouton actif */
.menu-btn.active {
    background: #ff0000;
    color: #000;
}

.menu-toggle {
    position: fixed;
    top: 20px;
    right: 20px;
    background: rgba(0, 0, 0, 0.8);
    border: 1px solid #ff0000;
    border-radius: 8px;
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    z-index: 1000;
    transition: all 0.3s ease;
    overflow: hidden;
}

.menu-toggle svg {
    width: 24px;
    height: 24px;
    transition: transform 0.3s ease;
}

.menu-toggle svg path {
    stroke: #ff0000;
    stroke-width: 2;
    stroke-linecap: round;
    transition: all 0.3s ease;
}

.menu-toggle:hover {
    background: rgba(255, 0, 0, 0.1);
    box-shadow: 0 0 15px rgba(255, 0, 0, 0.3);
}

.menu-toggle:hover svg {
    transform: scale(1.1);
}

.menu-toggle:hover svg path {
    stroke-dasharray: 15;
    stroke-dashoffset: 20;
    animation: dash 1.5s linear infinite;
}

@keyframes dash {
    to {
        stroke-dashoffset: 0;
    }
}
/* Header du menu */
.menu-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 20px 20px;
    border-bottom: 1px solid rgba(255, 0, 0, 0.3);
    margin-bottom: 20px;
}

.menu-header span {
    color: #ff0000;
    font-size: 20px;
    font-weight: bold;
}

.close-menu {
    background: none;
    border: none;
    color: #ff0000;
    font-size: 20px;
    cursor: pointer;
    padding: 5px;
}

/* Animation du menu */
@keyframes slideIn {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

.nav-menu.active {
    animation: slideIn 0.3s ease forwards;
}

/* Classes pour cacher/montrer */
.hidden {
    display: none;
}

.menu-overlay.hidden {
    display: none;
}
.nav-menu.hidden {
    display: none;
}
/* Style du menu latéral et des boutons */
.nav-menu {
    position: fixed;
    top: 0;
    right: -300px;
    width: 300px;
    height: 100vh;
    background: rgba(0, 0, 0, 0.95);
    border-left: 1px solid #ff0000;
    padding: 20px;
    transition: all 0.3s ease;
    z-index: 1001;
    visibility: hidden;
}

.menu-btn i {
    width: 20px;
    text-align: center;
    font-size: 16px;
}
.nav-menu {
    position: fixed;
    top: 0;
    right: -300px;
    width: 300px;
    height: 100vh;
    background: rgba(0, 0, 0, 0.95);
    border-left: 1px solid #ff0000;
    padding: 20px;
    transition: all 0.3s ease;
    z-index: 1001;
    visibility: hidden;
}

.nav-menu.active {
    right: 0;
    visibility: visible;
}

.menu-container {
    display: flex;
    flex-direction: column;
    gap: 15px;
    padding: 0 20px;
}

.menu-btn {
    background: transparent;
    color: #ff0000;
    border: 1px solid #ff0000;
    border-radius: 5px;
    padding: 15px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 10px;
    width: 100%;
    text-align: left;
    font-size: 14px;
}
/* Supprimer les doublons et garder uniquement cette version */
.menu-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    z-index: 1000;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.menu-overlay.active {
    opacity: 1;
    visibility: visible;
}
.menu-btn:hover {
    background: #ff0000;
    color: #000;
    transform: translateX(5px);
    box-shadow: 0 0 15px rgba(255, 0, 0, 0.3);
}
/* Style pour le bouton de fermeture */
.close-menu {
    position: absolute;
    top: 15px;
    right: 15px;
    width: 30px;
    height: 30px;
    background: transparent;
    border: 2px solid #ff0000;
    border-radius: 50%;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    z-index: 1002;
}

.close-menu:hover {
    background: #ff0000;
    transform: rotate(90deg);
}

.close-menu svg {
    width: 14px;
    height: 14px;
    fill: none;
    stroke: #ff0000;
    stroke-width: 2;
    transition: all 0.3s ease;
}

.close-menu:hover svg {
    stroke: #000;
}

/* Style pour les icônes du menu */
.menu-btn svg {
    width: 20px;
    height: 20px;
    margin-right: 10px;
    fill: none;
    stroke: #ff0000;
    stroke-width: 2;
    transition: all 0.3s ease;
}

.menu-btn:hover svg {
    stroke: #000;
}
.delete-log-btn {
    background: transparent;
    border: none;
    cursor: pointer;
    padding: 5px;
    transition: all 0.3s ease;
    border-radius: 50%;
}

.delete-log-btn:hover {
    background: rgba(255, 0, 0, 0.1);
    transform: scale(1.1);
}

.delete-log-btn:hover .delete-icon path {
    stroke: #ff3333;
    stroke-width: 2.5;
}

.delete-icon {
    transition: all 0.3s ease;
}
/* ... existing code ... */
@keyframes sliceAndFade {
    0% {
        clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%);
        transform: translateX(0);
        opacity: 1;
    }
    30% {
        clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%);
        transform: translateX(5px);
        opacity: 1;
        background: rgba(255, 0, 0, 0.05);
    }
    40% {
        clip-path: polygon(0 0, 50% 0, 50% 100%, 0 100%);
        background: rgba(255, 0, 0, 0.1);
    }
    45% {
        clip-path: polygon(50% 0, 100% 0, 100% 100%, 50% 100%);
    }
    50% {
        clip-path: polygon(0 0, 49% 0, 49% 100%, 0 100%);
        transform: translateX(-30px);
        opacity: 0.9;
    }
    75% {
        clip-path: polygon(51% 0, 100% 0, 100% 100%, 51% 100%);
        transform: translateX(30px);
        opacity: 0.5;
    }
    100% {
        clip-path: polygon(0 0, 49% 0, 49% 100%, 0 100%),
                         polygon(51% 0, 100% 0, 100% 100%, 51% 100%);
        transform: translateX(-50px);
        opacity: 0;
    }
}

.slice-delete {
    position: relative;
    animation: sliceAndFade 1s cubic-bezier(0.65, 0, 0.35, 1) forwards;
}

.slice-delete::before {
    content: '';
    position: absolute;
    top: 0;
    left: 50%;
    width: 2px;
    height: 100%;
    background: linear-gradient(to bottom, 
        transparent, 
        rgba(255, 0, 0, 0.8),
        transparent
    );
    transform: translateX(-50%);
    opacity: 0;
    animation: sliceLine 0.3s ease-in forwards;
    animation-delay: 0.2s;
}

@keyframes sliceLine {
    0% {
        opacity: 0;
        transform: translateX(-50%) scaleY(0);
    }
    50% {
        opacity: 1;
        transform: translateX(-50%) scaleY(1);
    }
    100% {
        opacity: 0;
        transform: translateX(-50%) scaleY(0);
    }
}

    </style>
</head>

<body>

<canvas id="matrix-background" class="matrix-background"></canvas>

<script>
const canvas = document.getElementById('matrix-background');
const ctx = canvas.getContext('2d');


function resizeCanvas() {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
}
resizeCanvas();
window.addEventListener('resize', resizeCanvas);


const chars = '01'.split('');
const fontSize = 14;
const columns = canvas.width / fontSize;
const drops = [];


for (let i = 0; i < columns; i++) {
    drops[i] = Math.floor(Math.random() * canvas.height/fontSize);
}


function draw() {
    ctx.fillStyle = 'rgba(0, 0, 0, 0.05)';
    ctx.fillRect(0, 0, canvas.width, canvas.height);

    ctx.fillStyle = '#ff0000'; 
    ctx.font = fontSize + 'px monospace';

    for (let i = 0; i < drops.length; i++) {
        const text = chars[Math.floor(Math.random() * chars.length)];
        ctx.fillText(text, i * fontSize, drops[i] * fontSize);

        if (drops[i] * fontSize > canvas.height && Math.random() > 0.975) {
            drops[i] = 0;
        }
        drops[i]++;
    }
}


setInterval(draw, 35);


document.querySelectorAll('.btn, input[type="text"]').forEach(element => {
    element.addEventListener('mouseover', function() {
        this.style.textShadow = '0 0 10px #ff0000';
        this.style.boxShadow = '0 0 15px rgba(255, 0, 0, 0.5)';
    });

    element.addEventListener('mouseout', function() {
        this.style.textShadow = 'none';
        this.style.boxShadow = 'none';
    });
});
</script>
    <div class="header">
        <h1>Corleone Control Panel</h1>
        <div class="status"></div>
    </div>

    <div class="container-fluid">
        <h2>Visitor Logs</h2>
        <table id="visitorTable">
            <thead>
                <tr>
                    <th>IP Address</th>
                    <th>Date</th>
                    <th>ISP</th>
                    <th>Country</th>
                    <th>DeviceINFOS</th>
                    <th>Status</th>
                    <th>Navigateur</th>
                    <th>os</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <!-- Exemple de données -->

<tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-16 22:35:27</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-16 22:35:53</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/eg.png' alt='Egypt'> 196.129.79.163</td><td>2025-11-16 22:38:20</td><td>Vodafone Data</td><td>Egypt</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:14b:4985:adb0:1cb9:49b6:9d10:63ee</td><td>2025-11-16 22:41:09</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:f:d19::1</td><td>2025-11-16 22:46:50</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 172.85.15.42</td><td>2025-11-16 22:48:32</td><td>Breezeline</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4040:7b37:700:859f:332c:ad68:2b0f</td><td>2025-11-16 22:49:36</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4040:7b37:700:859f:332c:ad68:2b0f</td><td>2025-11-16 22:50:01</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 172.56.218.52</td><td>2025-11-16 22:51:24</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 76.202.86.0</td><td>2025-11-16 22:55:41</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-16 22:56:13</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:603:5000:5530:8cb9:d5d7:4068:ac3c</td><td>2025-11-16 22:56:55</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:19b:4201:8dc0:b99f:f30b:2834:5ac</td><td>2025-11-16 22:59:13</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:19b:4201:8dc0:b99f:f30b:2834:5ac</td><td>2025-11-16 22:59:18</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:19b:4201:8dc0:b99f:f30b:2834:5ac</td><td>2025-11-16 22:59:21</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-16 23:00:06</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:5:80d::25</td><td>2025-11-16 23:02:03</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/eg.png' alt='Egypt'> 196.129.79.163</td><td>2025-11-16 23:02:05</td><td>Vodafone Data</td><td>Egypt</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:19b:4300:5270:29aa:37a9:f375:520b</td><td>2025-11-16 23:02:56</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:986:4100:8940:5449:75cb:dff:d818</td><td>2025-11-16 23:03:52</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:986:4100:8940:5449:75cb:dff:d818</td><td>2025-11-16 23:03:54</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:444:881:e080:18a5:133a:64ac:b9e7</td><td>2025-11-16 23:05:11</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:49:0:d970:c02c:d4e:e6a8:dd23</td><td>2025-11-16 23:06:34</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 108.24.105.123</td><td>2025-11-16 23:08:06</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:541:1001:e530:7007:cfe1:55bf:bcb8</td><td>2025-11-16 23:11:32</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 172.56.43.178</td><td>2025-11-16 23:12:20</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:45:8100:75f0:103:90be:bf46:c6da</td><td>2025-11-16 23:14:01</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/eg.png' alt='Egypt'> 196.129.79.163</td><td>2025-11-16 23:15:01</td><td>Vodafone Data</td><td>Egypt</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1008:b22c:d92:f8f7:9251:53b4:8ae7</td><td>2025-11-16 23:15:07</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:9b08:4ed3:6d17:d14f:d7fb:9ec9</td><td>2025-11-16 23:16:59</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 136.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 72.186.228.246</td><td>2025-11-16 23:17:25</td><td>Charter Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:14e:c000:b840:f949:3ba:bbcf:23db</td><td>2025-11-16 23:17:28</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 72.186.228.246</td><td>2025-11-16 23:17:40</td><td>Charter Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.106.129.158</td><td>2025-11-16 23:18:51</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4040:2571:600:69b2:cf0:9a27:aa65</td><td>2025-11-16 23:19:45</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:8800:e83:af00:403a:136c:fdc4:cc0f</td><td>2025-11-16 23:23:07</td><td>Cox Communications Inc.</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:444:881:e080:bcd5:2af1:851c:163c</td><td>2025-11-16 23:23:22</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:19e:4478:cd70:7d2b:aa6f:d897:7e2f</td><td>2025-11-16 23:24:01</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:88:300:23c0:b0ad:bf13:156f:f9da</td><td>2025-11-16 23:24:09</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18c:8300:b6d0:34f6:2557:3705:483a</td><td>2025-11-16 23:24:49</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:8000:8500:1cf3:5967:7e61:1f8a:562d</td><td>2025-11-16 23:25:13</td><td>Charter Communications Inc</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 76.138.134.187</td><td>2025-11-16 23:25:14</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:681:5880:2ab0:6cbe:651c:8e42:9478</td><td>2025-11-16 23:25:34</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:249:1182:8b40:459b:da36:4ab6:1a5d</td><td>2025-11-16 23:25:42</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:681:5880:2ab0:6cbe:651c:8e42:9478</td><td>2025-11-16 23:26:07</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:244:4581:bd50:75e2:bad:657d:a094</td><td>2025-11-16 23:26:44</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:ec02:8427:35fd:231b:a223:2bc2</td><td>2025-11-16 23:28:58</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:3716::8</td><td>2025-11-16 23:29:01</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:243:c02:3d50:c805:7c4d:90e3:c14</td><td>2025-11-16 23:29:03</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/eg.png' alt='Egypt'> 196.129.79.163</td><td>2025-11-16 23:29:30</td><td>Vodafone Data</td><td>Egypt</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:4b:4780:d6e0:b935:d761:fb0f:d18f</td><td>2025-11-16 23:30:27</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:cf:8200:850::f1cb</td><td>2025-11-16 23:31:10</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18c:8300:b6d0:34f6:2557:3705:483a</td><td>2025-11-16 23:31:12</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:46:57f:aa20:316f:cb6b:2b86:33d3</td><td>2025-11-16 23:33:01</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Linux</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:840:4000:fb10:c273:3a2b:9830:c6d5</td><td>2025-11-16 23:35:50</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18f:803:6a10:3c81:3508:3059:85c</td><td>2025-11-16 23:36:28</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 16.6.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18f:803:6a10:3c81:3508:3059:85c</td><td>2025-11-16 23:36:50</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 16.6.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:5380:e7c6:c589:9519:abe4:eccb</td><td>2025-11-16 23:37:07</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:601:c01:7390:356f:f120:161f:d435</td><td>2025-11-16 23:38:35</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4040:7ea0:fd00:6536:9222:4ffa:1ca8</td><td>2025-11-16 23:39:18</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 75.172.14.156</td><td>2025-11-16 23:39:39</td><td>CenturyLink Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:14b:487f:ccc0:55d6:8d1b:6228:a8cf</td><td>2025-11-16 23:39:44</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:8000:3b00:3021:d044:8f59:929e:28f7</td><td>2025-11-16 23:39:58</td><td>Charter Communications Inc</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:500:8282:cb80:c553:80c7:36f8:eb06</td><td>2025-11-16 23:40:13</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 67.169.42.51</td><td>2025-11-16 23:42:26</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:84:8700:48e0:d0b7:1647:a8ff:a148</td><td>2025-11-16 23:42:40</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1008:b14e:9c0f:7d0a:979e:9bc8:b4b8</td><td>2025-11-16 23:43:40</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18e:d081:27e0:7c1d:3d93:8503:2a8</td><td>2025-11-16 23:43:44</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:40d:680:b9e0:8029:45b7:5882:b5ba</td><td>2025-11-16 23:44:17</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1008:b14e:9c0f:7d0a:979e:9bc8:b4b8</td><td>2025-11-16 23:44:54</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.171.42.33</td><td>2025-11-16 23:46:44</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 96.235.129.7</td><td>2025-11-16 23:47:05</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 70.229.205.39</td><td>2025-11-16 23:47:10</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:249:1580:1300:606d:8a05:8387:29b3</td><td>2025-11-16 23:47:13</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1003:b07e:e9da:8178:72b4:3e81:9c85</td><td>2025-11-16 23:47:50</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:6010:a100:5ea8:4d2b:e090:2071:b4f</td><td>2025-11-16 23:47:52</td><td>Charter Communications Inc</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:6010:a100:5ea8:4d2b:e090:2071:b4f</td><td>2025-11-16 23:48:12</td><td>Charter Communications Inc</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 63.200.11.156</td><td>2025-11-16 23:49:58</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:3716::8</td><td>2025-11-16 23:50:17</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:602:8682:fbf0:742a:11fc:9b3:85c4</td><td>2025-11-16 23:50:23</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:602:8682:fbf0:742a:11fc:9b3:85c4</td><td>2025-11-16 23:50:36</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:2c3:887f:2580:c802:d263:6f07:62ed</td><td>2025-11-16 23:51:11</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:602:8682:fbf0:742a:11fc:9b3:85c4</td><td>2025-11-16 23:51:39</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18f:983:340:bcdd:4c9c:6e7:c71d</td><td>2025-11-16 23:51:53</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2605:59c8:4ae0:b810:f110:17f9:d8b4:b877</td><td>2025-11-16 23:51:54</td><td>SpaceX Starlink</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4040:5f07:8400:f573:2aa4:eb5f:204d</td><td>2025-11-16 23:53:08</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 138.89.141.119</td><td>2025-11-16 23:53:26</td><td>Verizon Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2605:59c8:4ae0:b810:f110:17f9:d8b4:b877</td><td>2025-11-16 23:53:28</td><td>SpaceX Starlink</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2605:59c8:4ae0:b810:f110:17f9:d8b4:b877</td><td>2025-11-16 23:53:45</td><td>SpaceX Starlink</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:189:4780:ab70:2921:d335:448e:6601</td><td>2025-11-16 23:55:08</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:646:8f8c:4560:10b0:17a4:8e5b:4f59</td><td>2025-11-16 23:55:42</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:5:80d::95</td><td>2025-11-16 23:56:52</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-16 23:57:09</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4040:f05b:c200:e871:aa10:a3ff:bbf8</td><td>2025-11-16 23:57:32</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:80:c101:11d0:a148:5042:e8ca:9287</td><td>2025-11-16 23:58:24</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:5c8:427f:8930:2949:8de0:42ad:2ab</td><td>2025-11-16 23:58:53</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:3cb:b00:30b0:b176:1fbd:fe1a:83d1</td><td>2025-11-16 23:59:56</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 45.30.106.112</td><td>2025-11-17 00:00:23</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:19b:4301:a9c0:4d46:9295:cc01:3d2c</td><td>2025-11-17 00:00:59</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:8000:8500:1cf3:5967:7e61:1f8a:562d</td><td>2025-11-17 00:02:17</td><td>Charter Communications Inc</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 71.181.35.67</td><td>2025-11-17 00:02:35</td><td>Consolidated Communications, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb91:29:c961:d5cf:ad68:f3ec:5127</td><td>2025-11-17 00:03:12</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1008:b094:190a:1534:223d:d65c:588b</td><td>2025-11-17 00:04:03</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:401:8200:f90:1deb:f7ed:71e8:4aaa</td><td>2025-11-17 00:04:15</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.219.230.221</td><td>2025-11-17 00:04:40</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:3716::8</td><td>2025-11-17 00:05:49</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb91:29:c961:d5cf:ad68:f3ec:5127</td><td>2025-11-17 00:06:54</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:581:8180:a100:81e5:6c55:b8ea:4d07</td><td>2025-11-17 00:07:28</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:3716::8</td><td>2025-11-17 00:07:32</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:3716::8</td><td>2025-11-17 00:07:37</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:4902:e890:44b9:3907:dbfe:93bc</td><td>2025-11-17 00:08:34</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 198.145.123.38</td><td>2025-11-17 00:09:14</td><td>Mecklenburg Electric Cooperative</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:348:600:4660:e187:1838:af13:50f3</td><td>2025-11-17 00:10:53</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:85:ca01:1420:f71b:d71b:2d0f:7e05</td><td>2025-11-17 00:10:56</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:8c:4700:e9b0:d42f:89a2:1cc:9b4</td><td>2025-11-17 00:11:26</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:640:cb80:60b0:7542:3a9c:624d:4bda</td><td>2025-11-17 00:13:30</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:646:9e02:ffc0:6121:116:25e4:52c6</td><td>2025-11-17 00:16:02</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:480a:60d0:fc00:4991:227c:156a:2d0b</td><td>2025-11-17 00:16:11</td><td>Cablevision Systems Corp.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:646:9e02:ffc0:6121:116:25e4:52c6</td><td>2025-11-17 00:16:22</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:4900:3af0:9084:baad:2d77:9227</td><td>2025-11-17 00:17:48</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18f:284:5590:1135:df32:1f8f:cea3</td><td>2025-11-17 00:18:36</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:4900:3af0:9084:baad:2d77:9227</td><td>2025-11-17 00:18:56</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:5061:cc21:522e:ec8e</td><td>2025-11-17 00:19:18</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:243:301:e070:3c03:3d4f:18b9:6784</td><td>2025-11-17 00:19:19</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 15.6.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:243:301:e070:3c03:3d4f:18b9:6784</td><td>2025-11-17 00:19:25</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 15.6.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:5061:cc21:522e:ec8e</td><td>2025-11-17 00:21:41</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:147:4a80:6690:2466:3481:6bd6:3c2b</td><td>2025-11-17 00:21:47</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 98.46.165.113</td><td>2025-11-17 00:21:52</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 17.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:5061:cc21:522e:ec8e</td><td>2025-11-17 00:22:10</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 108.25.78.75</td><td>2025-11-17 00:23:28</td><td>Verizon Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 108.25.78.75</td><td>2025-11-17 00:23:36</td><td>Verizon Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 205.178.24.23</td><td>2025-11-17 00:24:49</td><td>RCN</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:406:8100:d30:f57f:decf:6987:8716</td><td>2025-11-17 00:25:34</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:44:437f:31cb:e8fe:a724:ca7:730a</td><td>2025-11-17 00:25:59</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:681:8d80:4fa0:f145:e178:8929:8d3c</td><td>2025-11-17 00:27:42</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:406:8100:d30:f57f:decf:6987:8716</td><td>2025-11-17 00:28:25</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:195:c800:9450:e195:e9c5:d013:8102</td><td>2025-11-17 00:30:22</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:640:cb80:60b0:7542:3a9c:624d:4bda</td><td>2025-11-17 00:30:34</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1000:b0f5:4e01:d433:812a:77f1:395b</td><td>2025-11-17 00:33:41</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.4</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:8c:4700:e9b0:d42f:89a2:1cc:9b4</td><td>2025-11-17 00:33:52</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1700:bc1:1350:e5ed:9ad2:a0ff:3c14</td><td>2025-11-17 00:34:33</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.1.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:195:c800:9450:e195:e9c5:d013:8102</td><td>2025-11-17 00:34:45</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 71.184.217.63</td><td>2025-11-17 00:34:53</td><td>Verizon Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:8c:4700:e9b0:d42f:89a2:1cc:9b4</td><td>2025-11-17 00:34:54</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:182:83:e8e0:e4d0:350e:7ec4:3596</td><td>2025-11-17 00:37:51</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:2c3:cd00:16b0:7076:d8ee:6b2c:534a</td><td>2025-11-17 00:41:20</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:406:8100:d30:f57f:decf:6987:8716</td><td>2025-11-17 00:41:24</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:240:4582:7f90:edc2:b78d:e14:67d8</td><td>2025-11-17 00:43:10</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:1c0:4380:ee0:c4c0:ba9a:c983:9d28</td><td>2025-11-17 00:43:50</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPad</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb92:2c05:cd82:fd1b:5439:1ff3:c13e</td><td>2025-11-17 00:44:14</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:381:cbf2:6a91:4ccf:5136:2c45:614b</td><td>2025-11-17 00:49:22</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:40:c882:c000:adb3:86aa:6ed6:e344</td><td>2025-11-17 00:49:30</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2604:5c80:200:b2a:68b7:fea6:e11c:bbac</td><td>2025-11-17 00:51:36</td><td>Easton Utilities Commission</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 67.169.42.51</td><td>2025-11-17 00:52:04</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:540:ca81:87a0:59a1:1aa5:71ee:21d1</td><td>2025-11-17 00:53:36</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1700:37be:6480:e5d2:4479:ca4b:ce14</td><td>2025-11-17 00:55:03</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.244.12.58</td><td>2025-11-17 00:55:35</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb92:1980:3a89:6d3b:54c1:cc47:c28a</td><td>2025-11-17 00:55:56</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:100f:a112:eac4:580e:cdc1:bec3:2ae5</td><td>2025-11-17 00:56:57</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2604:5c80:200:b2a:68b7:fea6:e11c:bbac</td><td>2025-11-17 00:57:00</td><td>Easton Utilities Commission</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb92:2c05:cd82:fd1b:5439:1ff3:c13e</td><td>2025-11-17 00:58:09</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 98.209.184.83</td><td>2025-11-17 01:00:13</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:207:380:e860:5885:3c8f:c148:6e46</td><td>2025-11-17 01:01:29</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:c:6e16::c</td><td>2025-11-17 01:04:51</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:602:8702:8ba5:e567:a93c:9696:7a7c</td><td>2025-11-17 01:07:04</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:602:8702:8ba5:e567:a93c:9696:7a7c</td><td>2025-11-17 01:07:46</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:589:4d7f:bb10:8950:241b:5858:aa01</td><td>2025-11-17 01:10:05</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:589:4d7f:bb10:8950:241b:5858:aa01</td><td>2025-11-17 01:10:14</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 206.85.193.20</td><td>2025-11-17 01:11:08</td><td>Yadkin Valley Telephone Membership Corporation</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:540:ca81:87a0:59a1:1aa5:71ee:21d1</td><td>2025-11-17 01:11:09</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:ad04:847e:280a:63ff:fe69:3b4d</td><td>2025-11-17 01:11:41</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 143.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.113.67.43</td><td>2025-11-17 01:15:21</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:45ae:801b:3c44:97c0:303d:9738</td><td>2025-11-17 01:16:50</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:45ae:801b:3c44:97c0:303d:9738</td><td>2025-11-17 01:16:51</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:283:4e84:dde0:2c62:fdd1:7247:cb77</td><td>2025-11-17 01:21:05</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:6c0:8200:a090:857d:79b8:ec8f:72f7</td><td>2025-11-17 01:22:42</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:9b3b:ce10:ad2:e351:b222:5161</td><td>2025-11-17 01:24:52</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 98.63.219.223</td><td>2025-11-17 01:26:26</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:189:4100:eaf0:d5ff:c44b:1c6c:cec5</td><td>2025-11-17 01:26:50</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:182:b01:4260:6d0e:d5ee:2fb1:cbbe</td><td>2025-11-17 01:28:15</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:280:5182:e560:d015:64e6:78e6:623d</td><td>2025-11-17 01:29:00</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:640:8c00:fda0:30a1:a875:9eaa:8a9e</td><td>2025-11-17 01:29:46</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:6c4:200:c1e0:a5d7:6bf6:5a5e:c21e</td><td>2025-11-17 01:32:11</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 104.203.9.185</td><td>2025-11-17 01:32:56</td><td>Blue Stream</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:602:c480:12b0:ac75:49c5:de23:74f9</td><td>2025-11-17 01:38:13</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPad</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:201:8202:a150:7914:fd0f:9a21:d1bd</td><td>2025-11-17 01:40:00</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:288d:764c:ef2:d312</td><td>2025-11-17 01:48:23</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18c:cc00:8b80:8801:527d:3e6d:5c7f</td><td>2025-11-17 01:49:00</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1702:8270:b700:2055:a341:cee1:5b03</td><td>2025-11-17 01:51:35</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:647:c001:ee00:8a0:8654:749d:b6c9</td><td>2025-11-17 01:53:37</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1702:8270:b700:2055:a341:cee1:5b03</td><td>2025-11-17 01:54:20</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18c:8900:45c0:7c52:88b5:16a2:e8aa</td><td>2025-11-17 01:59:55</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:288d:764c:ef2:d312</td><td>2025-11-17 02:00:00</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1008:b05a:36e8:792f:8112:ccb9:6e10</td><td>2025-11-17 02:01:40</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:4900:3af0:9084:baad:2d77:9227</td><td>2025-11-17 02:04:13</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58a:8e84:c860:659f:a675:e43c:2e40</td><td>2025-11-17 02:06:06</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1008:b01b:9d9d:4fa:cbf1:a692:670b</td><td>2025-11-17 02:06:26</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:1434::3</td><td>2025-11-17 02:06:28</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:4900:3af0:9084:baad:2d77:9227</td><td>2025-11-17 02:06:54</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:4900:3af0:9084:baad:2d77:9227</td><td>2025-11-17 02:06:56</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:c2:1e00:a7e0:507d:5f28:fea4:43a0</td><td>2025-11-17 02:10:31</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 69.5.133.129</td><td>2025-11-17 02:12:24</td><td>ICS Advanced Technologies</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 38.187.156.141</td><td>2025-11-17 02:14:52</td><td>BTC Broadband Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:937f:cb0:8a2d:c621:85f6:93f</td><td>2025-11-17 02:18:04</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Linux</td><td>Chrome 136.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58b:f01:2a50:1124:41b0:4861:f230</td><td>2025-11-17 02:18:08</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:380:8101:480:f815:2f0e:a00e:be08</td><td>2025-11-17 02:36:20</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:5f80:9c0:a55f:f742:47b8:6a13</td><td>2025-11-17 02:42:25</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:7409:5f1:9177:3949:9c83:e7e0</td><td>2025-11-17 02:43:26</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb92:1c85:9e08:f8e8:9b27:8df3:e1b4</td><td>2025-11-17 02:43:30</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:7409:5f1:9177:3949:9c83:e7e0</td><td>2025-11-17 02:43:47</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:5f80:9c0:a55f:f742:47b8:6a13</td><td>2025-11-17 02:44:00</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1008:a030:90fc:7492:bc3a:26d9:2935</td><td>2025-11-17 02:44:12</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:3c8:427e:12b3:fb70:a246:5cb2:4da9</td><td>2025-11-17 02:45:29</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1700:479f:8810:8584:2d75:91da:b9d9</td><td>2025-11-17 02:45:57</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Opera 92.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:444:783:36e0:687c:746b:6a29:b79e</td><td>2025-11-17 02:48:40</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1700:8600:4140:fc8a:7f63:ae2d:11ce</td><td>2025-11-17 02:51:25</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.72.112.186</td><td>2025-11-17 02:55:47</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.72.112.186</td><td>2025-11-17 02:58:52</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.72.112.186</td><td>2025-11-17 03:07:44</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:84:847e:1a00:f755:ddbc:de90:7c9d</td><td>2025-11-17 03:08:25</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:80:4a00:48a0:cc0:b042:3bf1:ad0a</td><td>2025-11-17 03:12:33</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:883:c200:1f0:ac98:4784:5e10:9183</td><td>2025-11-17 03:17:02</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:640:8e80:d70:e1cc:edb1:8bbd:67f9</td><td>2025-11-17 03:19:18</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:205:4781:9510:ec7f:8f53:9c9:64ba</td><td>2025-11-17 03:24:59</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:646:9e00:7b00:6da6:1660:ea74:53cb</td><td>2025-11-17 03:26:30</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:43:c201:e640:a0b8:580e:b881:18e</td><td>2025-11-17 03:27:22</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:3cb:800:e060:4bb:356:acbe:e042</td><td>2025-11-17 03:27:40</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPad</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:43:c201:e640:a0b8:580e:b881:18e</td><td>2025-11-17 03:28:54</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:c:6e16::c</td><td>2025-11-17 03:31:09</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:43:c201:e640:a0b8:580e:b881:18e</td><td>2025-11-17 03:31:29</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 205.178.24.23</td><td>2025-11-17 03:37:35</td><td>RCN</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 75.74.188.239</td><td>2025-11-17 03:39:29</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4040:b4d8:b700:a04a:1da9:d29e:33cc</td><td>2025-11-17 03:46:42</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 98.60.50.67</td><td>2025-11-17 03:48:23</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.188.72.253</td><td>2025-11-17 03:49:41</td><td>Cox Communications Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:985:580:5080:f913:7c2e:5235:4817</td><td>2025-11-17 04:06:34</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:640:cb80:60b0:611f:1b01:9d19:de1</td><td>2025-11-17 04:12:41</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:540:c300:3cd0:27:2418:3276:9bf7</td><td>2025-11-17 13:19:53</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:182:b01:4260:6d0e:d5ee:2fb1:cbbe</td><td>2025-11-17 13:20:35</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:540:c300:3cd0:27:2418:3276:9bf7</td><td>2025-11-17 13:23:42</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:7081:64f0:2e40:8424:a6cf:5a7a:5f9</td><td>2025-11-17 13:25:18</td><td>Charter Communications Inc</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:540:c300:3cd0:27:2418:3276:9bf7</td><td>2025-11-17 13:25:26</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:540:c300:3cd0:27:2418:3276:9bf7</td><td>2025-11-17 13:27:06</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:243:c04:2780:2df8:77ae:61da:2f15</td><td>2025-11-17 13:27:25</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:3015:2f38:100:7968:73cd:6472:dd13</td><td>2025-11-17 13:30:01</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:3015:2f38:100:7968:73cd:6472:dd13</td><td>2025-11-17 13:31:13</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:92b6:19c:4125:eda7:fe7c:8d74</td><td>2025-11-17 13:32:11</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:6013:b800:3c87:51e6:1fbb:df95:b33d</td><td>2025-11-17 13:32:40</td><td>Charter Communications Inc</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:602:9601:ab0:f49c:ee2:8e71:1283</td><td>2025-11-17 13:33:30</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 76.190.12.90</td><td>2025-11-17 13:35:13</td><td>Spectrum</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:46:c47c:2350:b4ae:c3af:f5bf:d2d2</td><td>2025-11-17 13:37:12</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:41:c482:d950:2adc:88a5:8833:8dbc</td><td>2025-11-17 13:38:18</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 136.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2605:59c8:6075:4008:838d:6b8f:43da:778d</td><td>2025-11-17 13:42:46</td><td>SpaceX Starlink</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 69.255.127.247</td><td>2025-11-17 13:45:53</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:985:d83:4710:18a9:4c8f:bb95:fac3</td><td>2025-11-17 13:50:32</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:281:d600:64e0:4595:694:adab:98df</td><td>2025-11-17 13:53:16</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:985:d83:4710:18a9:4c8f:bb95:fac3</td><td>2025-11-17 13:55:45</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:985:d83:4710:18a9:4c8f:bb95:fac3</td><td>2025-11-17 14:00:35</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 134.199.111.98</td><td>2025-11-17 14:01:35</td><td>Hotwire Communications</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1017:b818:58c7:8170:8afa:ce71:fc05</td><td>2025-11-17 14:02:21</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:985:d83:4710:18a9:4c8f:bb95:fac3</td><td>2025-11-17 14:04:26</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.15.215.230</td><td>2025-11-17 14:06:36</td><td>Frontier Communications Solutions</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.15.215.230</td><td>2025-11-17 14:12:25</td><td>Frontier Communications Solutions</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.15.215.230</td><td>2025-11-17 14:12:35</td><td>Frontier Communications Solutions</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.15.215.230</td><td>2025-11-17 14:14:20</td><td>Frontier Communications Solutions</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 69.173.97.133</td><td>2025-11-17 14:14:29</td><td>The Broad Institute, Inc.</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.15.215.230</td><td>2025-11-17 14:14:30</td><td>Frontier Communications Solutions</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 74.102.115.61</td><td>2025-11-17 14:17:32</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.15.215.230</td><td>2025-11-17 14:17:45</td><td>Frontier Communications Solutions</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.15.215.230</td><td>2025-11-17 14:19:46</td><td>Frontier Communications Solutions</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 199.204.87.124</td><td>2025-11-17 14:24:45</td><td>Metronet</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:3640:1022:1c20:9c16:9ccc:883e:9a8b</td><td>2025-11-17 14:32:54</td><td>BIF IV</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:280:4901:1f30:9c11:f035:8933:d8f8</td><td>2025-11-17 14:36:11</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4041:413c:7800:e110:fc29:a75a:9363</td><td>2025-11-17 14:37:09</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18f:281:3d90:214a:27d0:8a5b:d00d</td><td>2025-11-17 14:40:32</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 69.251.88.7</td><td>2025-11-17 14:41:16</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 74.102.115.61</td><td>2025-11-17 14:44:51</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:240:8000:12:755a:af05:2bb1:72d3</td><td>2025-11-17 14:50:08</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:4900:3af0:9084:baad:2d77:9227</td><td>2025-11-17 14:50:46</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:98a:4400:5000:3c56:ac7f:6ff1:bfad</td><td>2025-11-17 14:59:22</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1700:479f:8810:16a1:b151:8a05:eac4</td><td>2025-11-17 14:59:49</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Opera 92.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18a:8380:8130:951a:3c6b:e453:b95e</td><td>2025-11-17 15:07:11</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58a:8e84:c860:2d4e:1c5f:3c5c:ed1e</td><td>2025-11-17 15:09:33</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:547:c97e:aaf0:4c7e:75f0:faef:9cc3</td><td>2025-11-17 15:12:10</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPad</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:2c4:4001:fd90:be04:8d74:abce:6248</td><td>2025-11-17 15:13:02</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 67.175.104.150</td><td>2025-11-17 15:22:31</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.14</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 50.212.240.37</td><td>2025-11-17 15:26:22</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/eg.png' alt='Egypt'> 196.129.53.151</td><td>2025-11-17 15:30:52</td><td>Vodafone Data</td><td>Egypt</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:1c2:c087:4bb0:ecec:1955:be3:9438</td><td>2025-11-17 15:34:16</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 17.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:3c12::7</td><td>2025-11-17 15:45:39</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:3005:800:7700:3c0c:464:ef8f:4eed</td><td>2025-11-17 15:46:10</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 104.203.7.201</td><td>2025-11-17 15:49:51</td><td>Blue Stream</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:3714::8</td><td>2025-11-17 15:52:21</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:7c0:cb01:3170:a91b:eb5e:d0bd:e001</td><td>2025-11-17 15:58:30</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:3024:2301:6300:984c:84a0:2a02:92af</td><td>2025-11-17 16:01:37</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:189:8501:6520:1108:3035:cb75:d369</td><td>2025-11-17 16:04:13</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 96.75.140.197</td><td>2025-11-17 16:05:44</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:8f00:2480:3d17:b0ac:e3c6:65b9</td><td>2025-11-17 16:13:26</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 50.39.230.30</td><td>2025-11-17 16:13:59</td><td>Wholesail networks LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 164.52.253.226</td><td>2025-11-17 16:15:43</td><td>DQE Communications LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 107.1.23.2</td><td>2025-11-17 16:18:02</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1002:b181:9100:14ca:2040:7a56:7c50</td><td>2025-11-17 16:19:14</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 164.52.253.226</td><td>2025-11-17 16:19:31</td><td>DQE Communications LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 131.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58b:580:7450:7935:51b:439:953b</td><td>2025-11-17 16:25:15</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1005:b30d:f8e:70a2:f2ae:cc9b:56e1</td><td>2025-11-17 16:25:57</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:1c2:4900:3fc0:61ae:323e:64e9:5c42</td><td>2025-11-17 16:27:02</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb91:3f0e:61cf:94e7:a68e:f3d1:d1b2</td><td>2025-11-17 16:38:11</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:387:15:1c15::5</td><td>2025-11-17 16:44:34</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:8e2d:9f36:d8ef:2e7:2067:4cf5</td><td>2025-11-17 16:47:26</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 136.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 75.147.25.177</td><td>2025-11-17 16:51:03</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 75.144.140.37</td><td>2025-11-17 16:52:05</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:84:8700:a890:25e8:8d9f:759d:9130</td><td>2025-11-17 16:55:02</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-17 16:55:27</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 67.187.180.31</td><td>2025-11-17 17:02:02</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 75.149.204.161</td><td>2025-11-17 17:06:21</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 75.149.204.161</td><td>2025-11-17 17:07:19</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 75.149.204.161</td><td>2025-11-17 17:14:31</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1000:b091:7343:a884:d904:fff2:7ddb</td><td>2025-11-17 17:16:26</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:3024:501:3a00:a13c:8264:bd5a:c96e</td><td>2025-11-17 17:21:07</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:45:400:7f60:1d0a:8380:46c8:a71</td><td>2025-11-17 17:23:54</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Firefox 145.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 70.95.251.133</td><td>2025-11-17 17:25:55</td><td>Spectrum</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 138.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 174.196.131.135</td><td>2025-11-17 17:31:28</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 104.55.211.135</td><td>2025-11-17 17:34:47</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 132.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1008:b09a:3a62:3d70:54dc:d974:d1fd</td><td>2025-11-17 17:35:54</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 136.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb91:81e:922d:c004:3113:b0a6:f11b</td><td>2025-11-17 17:40:49</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:300a:985:5500:3d2a:f095:b6b5:95c3</td><td>2025-11-17 17:47:43</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:603:784:d1d0:9406:36c1:deb9:27de</td><td>2025-11-17 17:58:01</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:603:784:d1d0:9406:36c1:deb9:27de</td><td>2025-11-17 18:00:34</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:41d1:e814:9da8:30e4</td><td>2025-11-17 18:05:09</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:84:c500:1e60:69e2:4a3f:bcfe:120f</td><td>2025-11-17 18:11:24</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:41d1:e814:9da8:30e4</td><td>2025-11-17 18:12:29</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 199.204.87.124</td><td>2025-11-17 18:12:59</td><td>Metronet</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 71.227.153.88</td><td>2025-11-17 18:17:02</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:41d1:e814:9da8:30e4</td><td>2025-11-17 18:18:30</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:41d1:e814:9da8:30e4</td><td>2025-11-17 18:19:58</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:8f00:2480:bdfb:69f:e0a6:5784</td><td>2025-11-17 18:27:40</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2604:a200:8001:596:134f:8ca4:6e20:3410</td><td>2025-11-17 18:34:43</td><td>All West Communications, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:41d1:e814:9da8:30e4</td><td>2025-11-17 18:42:24</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:243:200:5510:89da:28ce:ad9:1800</td><td>2025-11-17 18:42:39</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:382:2772:e135:6c6b:3033:8c8b:a274</td><td>2025-11-17 18:43:17</td><td>AT&T Enterprises, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:644:9101:86b0:41d1:e814:9da8:30e4</td><td>2025-11-17 18:47:56</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 17.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:4040:5edd:7900:28c3:8b36:222c:8f37</td><td>2025-11-17 18:48:17</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:205:4781:9510:ec7f:8f53:9c9:64ba</td><td>2025-11-17 18:51:52</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:7c0:cb01:3170:e0c0:7569:602a:5169</td><td>2025-11-17 18:53:41</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:7c0:cb01:3170:e0c0:7569:602a:5169</td><td>2025-11-17 18:55:01</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 69.253.34.199</td><td>2025-11-17 19:06:23</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 75.147.25.177</td><td>2025-11-17 19:28:41</td><td>Comcast Cable Communications</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58b:4400:b2f0:98b3:7f2b:21da:814</td><td>2025-11-17 19:30:55</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 98.51.12.99</td><td>2025-11-17 19:36:47</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb91:101e:87d1:e434:2eb4:b93b:67c4</td><td>2025-11-17 19:41:57</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58d:300:3c70:19f5:9ea4:3423:be27</td><td>2025-11-17 19:44:35</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58d:300:3c70:19f5:9ea4:3423:be27</td><td>2025-11-17 19:45:08</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58d:300:3c70:19f5:9ea4:3423:be27</td><td>2025-11-17 19:45:15</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58d:300:3c70:19f5:9ea4:3423:be27</td><td>2025-11-17 19:45:22</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:280:ce81:aff0:35f4:6ee6:1210:c03b</td><td>2025-11-17 20:08:35</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:9b3b:ce10:ad2:e351:b222:5161</td><td>2025-11-17 20:12:11</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:9b3b:ce10:ad2:e351:b222:5161</td><td>2025-11-17 20:12:59</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1010:b019:c254:5018:b26f:f230:f12d</td><td>2025-11-17 20:14:02</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 141.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:280:ce81:aff0:35f4:6ee6:1210:c03b</td><td>2025-11-17 20:17:56</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:346:b01:470:bd08:91ee:dace:11df</td><td>2025-11-17 20:18:04</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 16.6.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:280:ce81:aff0:35f4:6ee6:1210:c03b</td><td>2025-11-17 20:26:21</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.7.2</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:346:b01:470:bd08:91ee:dace:11df</td><td>2025-11-17 20:28:34</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 16.6.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 69.251.88.7</td><td>2025-11-17 20:44:48</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:246:4900:3af0:4c89:7cba:7456:3e52</td><td>2025-11-17 20:49:12</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ca.png' alt='Canada'> 198.53.135.83</td><td>2025-11-17 21:02:00</td><td>TELUS Communications Inc</td><td>Canada</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPad</td><td>Safari 11.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 104.237.122.90</td><td>2025-11-17 21:18:03</td><td>Eastern Iowa IP, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 184.188.72.227</td><td>2025-11-17 21:21:34</td><td>Cox Communications Inc.</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari unknown</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:547:ce02:a980:4c3d:1ec9:7e8b:4b4d</td><td>2025-11-17 21:28:43</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 138.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:547:ce02:a980:4c3d:1ec9:7e8b:4b4d</td><td>2025-11-17 21:33:46</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 138.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:5c6:c380:8ef0:2913:f08d:a16e:d246</td><td>2025-11-17 21:33:56</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2600:1011:b104:f88f:81:378b:ea11:beff</td><td>2025-11-17 21:34:34</td><td>Verizon Business</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 73.117.35.67</td><td>2025-11-17 21:42:48</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Chrome 138.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:8ea6:8492:65d3:27dc:cf98:7588</td><td>2025-11-17 21:51:09</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2607:fb90:8ea6:8492:65d3:27dc:cf98:7588</td><td>2025-11-17 21:54:00</td><td>T-Mobile USA, Inc.</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 10:47:21</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr></tbody>
        </table>

<div class="menu-toggle" onclick="toggleMenu()">
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path class="line line-1" d="M3 6H21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
        <path class="line line-2" d="M3 12H21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
        <path class="line line-3" d="M3 18H21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
    </svg>
</div>

<!-- Menu latéral -->
<nav class="nav-menu">
    <div class="menu-header">
        <span>Menu</span>
        <button class="close-menu" onclick="toggleMenu()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    <div class="menu-container">
        <button class="menu-btn" onclick="showBanForm()">
            <i class="fas fa-ban"></i>
            Ban IP
        </button>
        <button class="menu-btn" onclick="showAllowedCountries()">
            <i class="fas fa-globe"></i>
            Allowed Countries
        </button>
        <button class="menu-btn" onclick="showBannedIPs()">
            <i class="fas fa-list"></i>
            Show Banned IPs
        </button>
        <button class="menu-btn" onclick="clearLogs()">
            <i class="fas fa-trash-alt"></i>
            Clear Logs
        </button>
        <button class="menu-btn" onclick="toggleIframe()">
            <i class="fas fa-chart-line"></i>
            Status en temps réel
        </button>
    </div>
</nav>

<div class="menu-overlay" onclick="toggleMenu()"></div>

        <div id="captchaContainer"></div>
    </div>

    <div class="notifications" id="notifications"></div>

    <footer>
        <p>Powered by @corleone776 | 2025</p>
    </footer>

    <script>
        let currentIp = "";

        function setIpAction() {
            const ipField = document.getElementById("ipAddress");
            currentIp = ipField.value;
            if (currentIp) {
                showNotification(`IP ${currentIp} définie avec succès ✅ .`);
                ipField.value = ""; 
            } else {
                showNotification("Veuillez entrer une adresse IP valide ❌.", "error");
            }
        }

        function performAction(action) {
            if (!currentIp) {
                showNotification("Veuillez d'abord définir une adresse IP ❌ .", "error");
                return;
            }

            showNotification(`Action ${action.toUpperCase()} exécutée avec succès sur l'IP ${currentIp}.✅`);
        }
function clearLogs() {
   toggleMenu();
    fetch('status/clear-logs.php')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const tableBody = document.querySelector("#visitorTable tbody");
                tableBody.innerHTML = "";
                showNotification("Tous les logs ont été effacés avec succès ✅.");
            } else {
                showNotification("Erreur lors de la suppression des logs ❌.", "error");
            }
        })
        .catch(error => {
            showNotification("Erreur de connexion au serveur ❌.", "error");
        });
}

        function banIp() {
          toggleMenu();
            if (!currentIp) {
                showNotification("Veuillez d'abord définir une adresse IP ❌.", "error");
                return;
            }

            
            fetch('../panel/banip/ban-ip.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ ip: currentIp })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    showNotification(`IP ${currentIp} a été bloquée avec succès ✅.`);
                } else {
                    showNotification(data.message, 'error');
                }
            })
            .catch(error => {
                showNotification("Erreur de connexion au serveur ❌.", "error");
            });
        }

        function showNotification(message, type = "success") {
            const notification = document.createElement("div");
            notification.className = `notification ${type}`;
            notificatiotch(error => {
                showNotification("Erreur de connexion au serveur ❌.", "error");
            });
        }

        function showNotification(message, type = "success") {
            const notification = document.createElement("div");
            notification.className = `notification ${type}`;
            notification.textContent = message;

            const notificationsContainer = document.getElementById("notifications");
            notificationsContainer.appendChild(notification);

            setTimeout(() => {
                notificationsContainer.removeChild(notification);
            }, 5000);
        }

        function toggleSwitch() {
            const switchElement = document.getElementById('dynamicSwitch');
            const statusText = document.getElementById('switchStatus');
            const captchaMessage = document.getElementById('captchaMessage');
            if (switchElement.checked) {
                statusText.textContent = "Active";
                captchaMessage.textContent = "Captcha activé !";
                showNotification("Switch activated.");
            } else {
                statusText.textContent = "Inactive (activer ou desactiver le captcha)";
                captchaMessage.textContent = "activer ou desactiver le captcha";
                showNotification("Switch deactivated.");
            }
        }
    </script>
<script>
    function toggleIframe() {
    toggleMenu();
        const existingIframeContainer = document.getElementById("iframeContainer");

       
        if (existingIframeContainer) {
            existingIframeContainer.remove();
            showNotification("Affichage temps réel fermé ✅.");
        } else {

            const iframe = document.createElement("iframe");
            iframe.id = "realtimeIframe";
            iframe.src = "status/onlinesystem/status.html";
            iframe.style.position = "fixed";
            iframe.style.top = "50%";
            iframe.style.left = "50%";
            iframe.style.transform = "translate(-50%, -50%)";
            iframe.style.width = "80%";
            iframe.style.height = "80%";
            iframe.style.border = "2px solid #ff0000";
            iframe.style.borderRadius = "10px";
            iframe.style.backgroundColor = "#121212";
            iframe.style.zIndex = "1000";
            iframe.style.boxShadow = "0 4px 6px rgba(0, 0, 0, 0.8)";

            // Bouton de fermeture
            const closeButton = document.createElement("button");
            closeButton.textContent = "✖";
            closeButton.style.position = "absolute";
            closeButton.style.top = "10px";
            closeButton.style.right = "10px";
            closeButton.style.backgroundColor = "#ff4d4d";
            closeButton.style.color = "#fff";
            closeButton.style.border = "none";
            closeButton.style.borderRadius = "50%";
            closeButton.style.padding = "5px 10px";
            closeButton.style.cursor = "pointer";
            closeButton.style.zIndex = "1001";
            closeButton.onclick = function() {
                const container = document.getElementById("iframeContainer");
                if (container) {
                    container.remove();
                }
                showNotification("Affichage temps réel fermé ✅.");
            };

            // Conteneur pour iframe et bouton
            const iframeContainer = document.createElement("div");
            iframeContainer.id = "iframeContainer";
            iframeContainer.style.position = "fixed";
            iframeContainer.style.top = "0";
            iframeContainer.style.left = "0";
            iframeContainer.style.width = "100%";
            iframeContainer.style.height = "100%";
            iframeContainer.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
            iframeContainer.style.zIndex = "999";
            iframeContainer.appendChild(iframe);
            iframeContainer.appendChild(closeButton);

            document.body.appendChild(iframeContainer);
            showNotification("Affichage temps réel activé ✅.");
        }
    }


    function showNotification(message, type = "success") {
        const notification = document.createElement("div");
        notification.className = `notification ${type}`;
        notification.textContent = message;

        const notificationsContainer = document.getElementById("notifications") || createNotificationsContainer();
        notificationsContainer.appendChild(notification);

        setTimeout(() => {
            notification.remove();
        }, 5000);
    }


    function createNotificationsContainer() {
        const container = document.createElement("div");
        container.id = "notifications";
        container.style.position = "fixed";
        container.style.top = "20px";
        container.style.right = "20px";
        container.style.zIndex = "10000";
        container.style.display = "flex";
        container.style.flexDirection = "column";
        container.style.gap = "10px";
        document.body.appendChild(container);
        return container;
    }
</script>
<script>
function showBannedIPs() {
 toggleMenu();
    const iframeContainer = document.createElement("div");
    iframeContainer.id = "bannedIPsContainer";
    iframeContainer.style.position = "fixed";
    iframeContainer.style.top = "50%";
    iframeContainer.style.left = "50%";
    iframeContainer.style.transform = "translate(-50%, -50%)";
    iframeContainer.style.width = "80%";
    iframeContainer.style.maxWidth = "600px";
    iframeContainer.style.backgroundColor = "rgba(0, 0, 0, 0.95)";
    iframeContainer.style.border = "1px solid #ff0000";
    iframeContainer.style.borderRadius = "10px";
    iframeContainer.style.padding = "20px";
    iframeContainer.style.zIndex = "1000";
    iframeContainer.style.boxShadow = "0 0 20px rgba(255, 0, 0, 0.3)";

    // Header avec titre et bouton de fermeture
    const header = document.createElement("div");
    header.style.display = "flex";
    header.style.justifyContent = "space-between";
    header.style.alignItems = "center";
    header.style.marginBottom = "20px";

    const title = document.createElement("h2");
    title.textContent = "Banned IPs";
    title.style.color = "#ff0000";
    title.style.margin = "0";

    const closeButton = document.createElement("button");
    closeButton.textContent = "✖";
    closeButton.style.backgroundColor = "#ff0000";
    closeButton.style.color = "#fff";
    closeButton.style.border = "none";
    closeButton.style.borderRadius = "50%";
    closeButton.style.padding = "5px 10px";
    closeButton.style.cursor = "pointer";
    closeButton.onclick = () => iframeContainer.remove();

    header.appendChild(title);
    header.appendChild(closeButton);
    iframeContainer.appendChild(header);

    
const searchContainer = document.createElement("div");
searchContainer.style.marginBottom = "20px";
searchContainer.style.position = "relative";
searchContainer.style.width = "100%";
searchContainer.style.padding = "0 5px";

    const searchIcon = document.createElement("span");
    searchIcon.innerHTML = "🔍";
    searchIcon.style.position = "absolute";
    searchIcon.style.left = "10px";
    searchIcon.style.top = "50%";
    searchIcon.style.transform = "translateY(-50%)";
    searchIcon.style.color = "#ff0000";
    searchIcon.style.fontSize = "16px";

const searchInput = document.createElement("input");
searchInput.type = "text";
searchInput.placeholder = "Search IP...";
searchInput.style.width = "calc(100% - 10px)"; // Soustrait le padding pour un alignement parfait
searchInput.style.padding = "10px 35px";
searchInput.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
searchInput.style.border = "1px solid #ff0000";
searchInput.style.borderRadius = "5px";
searchInput.style.color = "#ff0000";
searchInput.style.fontSize = "14px";
searchInput.style.outline = "none";
searchInput.style.boxSizing = "border-box";

    // Animation de focus pour la barre de recherche
    searchInput.style.transition = "all 0.3s ease";
    searchInput.addEventListener('focus', () => {
        searchInput.style.boxShadow = "0 0 15px rgba(255, 0, 0, 0.3)";
    });
    searchInput.addEventListener('blur', () => {
        searchInput.style.boxShadow = "none";
    });

    searchContainer.appendChild(searchIcon);
    searchContainer.appendChild(searchInput);
    iframeContainer.appendChild(searchContainer);

const ipList = document.createElement("div");
ipList.style.maxHeight = "400px";
ipList.style.overflowY = "auto";
ipList.style.marginBottom = "20px";
ipList.style.width = "100%"; // Assure que la liste prend toute la largeur
ipList.style.boxSizing = "border-box"; // Inclut le padding dans la largeur
ipList.style.padding = "0 5px"; 

    // Stylisation de la scrollbar
    ipList.style.scrollbarWidth = "thin";
    ipList.style.scrollbarColor = "#ff0000 #1a1a1a";

    // Charger les IPs bannies
    fetch('unban-ip/get-banned-ips.php')
        .then(response => response.json())
        .then(data => {
            if (data.ips && data.ips.length > 0) {
                const createIPItem = (ip) => {
                    const ipItem = document.createElement("div");
                    ipItem.style.display = "flex";
                    ipItem.style.justifyContent = "space-between";
                    ipItem.style.alignItems = "center";
                    ipItem.style.padding = "10px";
                    ipItem.style.borderBottom = "1px solid #333";
                    ipItem.style.color = "#ff0000";
                    ipItem.style.transition = "all 0.3s ease";

                    const ipText = document.createElement("span");
                    ipText.textContent = ip;

                    const removeBtn = document.createElement("button");
                    removeBtn.textContent = "Unban";
                    removeBtn.className = "btn";
                    removeBtn.style.padding = "5px 10px";
                    removeBtn.style.fontSize = "0.8em";
                    removeBtn.style.backgroundColor = "transparent";
                    removeBtn.style.border = "1px solid #ff0000";
                    removeBtn.style.color = "#ff0000";
                    removeBtn.style.cursor = "pointer";
                    removeBtn.style.transition = "all 0.3s ease";

                    removeBtn.addEventListener('mouseover', () => {
                        removeBtn.style.backgroundColor = "#ff0000";
                        removeBtn.style.color = "#000";
                    });

                    removeBtn.addEventListener('mouseout', () => {
                        removeBtn.style.backgroundColor = "transparent";
                        removeBtn.style.color = "#ff0000";
                    });

                    removeBtn.onclick = () => unbanIP(ip, ipItem);

                    ipItem.appendChild(ipText);
                    ipItem.appendChild(removeBtn);
                    return ipItem;
                };

                // Fonction de filtrage
                const filterIPs = (searchTerm) => {
                    const items = ipList.children;
                    let hasVisibleItems = false;

                    Array.from(items).forEach(item => {
                        const ipText = item.firstChild.textContent.toLowerCase();
                        const matches = ipText.includes(searchTerm.toLowerCase());
                        item.style.display = matches ? "flex" : "none";
                        if (matches) hasVisibleItems = true;
                    });

                    // Afficher un message si aucun résultat
                    const noResults = ipList.querySelector('.no-results');
                    if (!hasVisibleItems) {
                        if (!noResults) {
                            const noResultsMsg = document.createElement("div");
                            noResultsMsg.className = 'no-results';
                            noResultsMsg.textContent = "No matching IPs found";
                            noResultsMsg.style.color = "#666";
                            noResultsMsg.style.textAlign = "center";
                            noResultsMsg.style.padding = "20px";
                            ipList.appendChild(noResultsMsg);
                        }
                    } else if (noResults) {
                        noResults.remove();
                    }
                };

                // Ajouter les IPs et configurer la recherche
                data.ips.forEach(ip => {
                    ipList.appendChild(createIPItem(ip));
                });

                searchInput.addEventListener('input', (e) => {
                    filterIPs(e.target.value);
                });

            } else {
                const noIPs = document.createElement("div");
                noIPs.textContent = "No banned IPs";
                noIPs.style.color = "#666";
                noIPs.style.textAlign = "center";
                noIPs.style.padding = "20px";
                ipList.appendChild(noIPs);
            }
        })
        .catch(error => {
            showNotification("Error loading banned IPs ❌", "error");
        });

    iframeContainer.appendChild(ipList);
    document.body.appendChild(iframeContainer);
}

function unbanIP(ip, element) {
    fetch('unban-ip/unban-ip.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ ip: ip })
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            element.remove();
            showNotification(`IP ${ip} has been unbanned ✅`);
        } else {
            showNotification("Error unbanning IP ❌", "error");
        }
    })
    .catch(error => {
        showNotification("Server error ❌", "error");
    });
}
</script>
<script>
let allowedCountries = new Set();

// Fonction pour charger les pays existants
function loadExistingCountries() {
    fetch('countryallowed/get-countries.php')
        .then(response => response.json())
        .then(data => {
            if (data.countries) {
                allowedCountries = new Set(data.countries);
                updateCountriesList();
            }
        })
        .catch(error => {
            console.log("Erreur lors du chargement des pays", error);
        });
}

// Fonction pour mettre à jour l'affichage de la liste
function updateCountriesList() {
    const container = document.getElementById('allowedCountriesList');
    container.innerHTML = '';
    
    allowedCountries.forEach(country => {
        const tag = document.createElement('div');
        tag.className = 'country-tag';
        tag.innerHTML = `
            ${country.toUpperCase()}
            <span class="remove" onclick="removeCountry('${country}')">✕</span>
        `;
        container.appendChild(tag);
    });
}

function addAllowedCountry(customCountryCode = null) {
    // Utiliser soit le code pays personnalisé, soit celui de l'input
    const countryCode = customCountryCode || document.getElementById('countryCode').value.trim().toLowerCase();
    
    if (!countryCode) return;

    if (allowedCountries.has(countryCode)) {
        showNotification(`Le pays ${countryCode.toUpperCase()} est déjà dans la liste ❌`, "error");
        return;
    }
    
    fetch('countryallowed/update-countries.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ 
            action: 'add',
            countryCode: countryCode 
        })
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Erreur réseau');
        }
        return response.json();
    })
    .then(data => {
        if (data.status === 'success') {
            allowedCountries.add(countryCode);
            updateCountriesList();
            // Si on utilise l'input original, le vider
            if (!customCountryCode) {
                document.getElementById('countryCode').value = '';
            }
            showNotification(`Pays ${countryCode.toUpperCase()} ajouté avec succès ✅`);
        } else {
            throw new Error(data.message || 'Erreur lors de l\'ajout du pays');
        }
    })
    .catch(error => {
        loadExistingCountries();
        showNotification("Mise à jour de la liste des pays ✅");
    });
}


document.addEventListener('DOMContentLoaded', loadExistingCountries);
function toggleOptions() {
 toggleMenu();
    const formContainer = document.querySelector('.form-container');
    const button = document.querySelector('.show-options-btn');
    
    if (formContainer.classList.contains('hidden')) {
        formContainer.classList.remove('hidden');
        button.textContent = 'Hide Options';
        // Animation Matrix plus intense pendant l'ouverture
        document.querySelector('.matrix-background').style.opacity = '0.2';
        setTimeout(() => {
            document.querySelector('.matrix-background').style.opacity = '0.1';
        }, 500);
    } else {
        formContainer.classList.add('hidden');
        button.textContent = 'Show Options';
        // Flash Matrix pendant la fermeture
        document.querySelector('.matrix-background').style.opacity = '0.2';
        setTimeout(() => {
            document.querySelector('.matrix-background').style.opacity = '0.1';
        }, 500);
    }
}

// Cacher le formulaire au chargement de la page
document.addEventListener('DOMContentLoaded', function() {
    const formContainer = document.querySelector('.form-container');
    formContainer.classList.add('hidden');
});
function toggleActiveButton(clickedButton) {
    document.querySelectorAll('.menu-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    clickedButton.classList.add('active');
}
function toggleMenu() {
    const menu = document.querySelector('.nav-menu');
    const overlay = document.querySelector('.menu-overlay');
    
    if (menu.classList.contains('active')) {
        // Fermeture du menu
        menu.style.right = '-300px';
        overlay.style.opacity = '0';
        
        requestAnimationFrame(() => {
            setTimeout(() => {
                menu.style.visibility = 'hidden';
                overlay.style.visibility = 'hidden';
                menu.classList.remove('active');
                overlay.classList.remove('active');
            }, 300);
        });
    } else {
        // Ouverture du menu
        menu.style.visibility = 'visible';
        overlay.style.visibility = 'visible';
        
        requestAnimationFrame(() => {
            menu.style.right = '0';
            overlay.style.opacity = '1';
            menu.classList.add('active');
            overlay.classList.add('active');
        });
    }
}

// Initialisation au chargement
document.addEventListener('DOMContentLoaded', function() {
    const menu = document.querySelector('.nav-menu');
    const overlay = document.querySelector('.menu-overlay');
    
    // État initial
    menu.style.right = '-300px';
    menu.style.visibility = 'hidden';
    overlay.style.visibility = 'hidden';
    overlay.style.opacity = '0';
    
    menu.classList.remove('active');
    overlay.classList.remove('active');
});

// Fermeture avec la touche Escape
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        const menu = document.querySelector('.nav-menu');
        if (menu.classList.contains('active')) {
            toggleMenu();
        }
    }
});
function showBanForm() {
    toggleMenu();
    
    const formContainer = document.createElement("div");
    formContainer.id = "banFormContainer";
    formContainer.style.position = "fixed";
    formContainer.style.top = "50%";
    formContainer.style.left = "50%";
    formContainer.style.transform = "translate(-50%, -50%)";
    formContainer.style.width = "80%";
    formContainer.style.maxWidth = "500px";
    formContainer.style.backgroundColor = "rgba(0, 0, 0, 0.95)";
    formContainer.style.border = "1px solid #ff0000";
    formContainer.style.borderRadius = "10px";
    formContainer.style.padding = "20px";
    formContainer.style.zIndex = "1000";
    formContainer.style.boxShadow = "0 0 20px rgba(255, 0, 0, 0.3)";

    // Header
    const header = document.createElement("div");
    header.style.display = "flex";
    header.style.justifyContent = "space-between";
    header.style.alignItems = "center";
    header.style.marginBottom = "20px";
    header.style.borderBottom = "1px solid rgba(255, 0, 0, 0.3)";
    header.style.paddingBottom = "10px";

    const title = document.createElement("h2");
    title.textContent = "Ban IP Address";
    title.style.color = "#ff0000";
    title.style.margin = "0";

    const closeButton = document.createElement("button");
    closeButton.innerHTML = "✖";
    closeButton.style.backgroundColor = "#ff0000";
    closeButton.style.color = "#fff";
    closeButton.style.border = "none";
    closeButton.style.borderRadius = "50%";
    closeButton.style.padding = "5px 10px";
    closeButton.style.cursor = "pointer";
    closeButton.onclick = () => formContainer.remove();

    header.appendChild(title);
    header.appendChild(closeButton);
    formContainer.appendChild(header);

    // Formulaire
    const input = document.createElement("input");
    input.type = "text";
    input.placeholder = "Enter IP address";
    input.style.width = "100%";
    input.style.padding = "10px";
    input.style.marginBottom = "15px";
    input.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
    input.style.border = "1px solid #ff0000";
    input.style.borderRadius = "5px";
    input.style.color = "#ff0000";
    input.style.outline = "none";

    const banButton = document.createElement("button");
    banButton.textContent = "Ban IP";
    banButton.className = "menu-btn";
    banButton.style.width = "100%";
    banButton.onclick = () => {
        const ip = input.value.trim();
        if (ip) {
            currentIp = ip;
            banIp();
            formContainer.remove();
        } else {
            showNotification("Veuillez entrer une adresse IP valide ❌", "error");
        }
    };

    formContainer.appendChild(input);
    formContainer.appendChild(banButton);
    document.body.appendChild(formContainer);
}

function showAllowedCountries() {
    toggleMenu();
    
    const container = document.createElement("div");
    container.id = "allowedCountriesContainer";
    container.style.position = "fixed";
    container.style.top = "50%";
    container.style.left = "50%";
    container.style.transform = "translate(-50%, -50%)";
    container.style.width = "80%";
    container.style.maxWidth = "600px";
    container.style.backgroundColor = "rgba(0, 0, 0, 0.95)";
    container.style.border = "1px solid #ff0000";
    container.style.borderRadius = "10px";
    container.style.padding = "20px";
    container.style.zIndex = "1000";
    container.style.boxShadow = "0 0 20px rgba(255, 0, 0, 0.3)";

    // Header
    const header = document.createElement("div");
    header.style.display = "flex";
    header.style.justifyContent = "space-between";
    header.style.alignItems = "center";
    header.style.marginBottom = "20px";
    header.style.borderBottom = "1px solid rgba(255, 0, 0, 0.3)";
    header.style.paddingBottom = "10px";

    const title = document.createElement("h2");
    title.textContent = "Allowed Countries";
    title.style.color = "#ff0000";
    title.style.margin = "0";

    const closeButton = document.createElement("button");
    closeButton.innerHTML = "✖";
    closeButton.style.backgroundColor = "#ff0000";
    closeButton.style.color = "#fff";
    closeButton.style.border = "none";
    closeButton.style.borderRadius = "50%";
    closeButton.style.padding = "5px 10px";
    closeButton.style.cursor = "pointer";
    closeButton.onclick = () => container.remove();

    header.appendChild(title);
    header.appendChild(closeButton);
    container.appendChild(header);

    // Container pour les switches
    const switchesContainer = document.createElement("div");
    switchesContainer.style.marginBottom = "20px";
    switchesContainer.style.padding = "15px";
    switchesContainer.style.border = "1px solid rgba(255, 0, 0, 0.3)";
    switchesContainer.style.borderRadius = "5px";
    switchesContainer.style.display = "flex";
    switchesContainer.style.flexDirection = "column";
    switchesContainer.style.gap = "15px";

    // Switch pour la vérification des pays
    const countryCheckContainer = document.createElement("div");
    countryCheckContainer.style.display = "flex";
    countryCheckContainer.style.alignItems = "center";
    countryCheckContainer.style.justifyContent = "space-between";

    const countryLabel = document.createElement("span");
    countryLabel.textContent = "check country";
    countryLabel.style.color = "#ff0000";

    const countrySwitch = document.createElement("label");
    countrySwitch.className = "switch";
    countrySwitch.innerHTML = `
        <input type="checkbox" id="countryCheck">
        <span class="slider"></span>
    `;
    countryCheckContainer.appendChild(countryLabel);
    countryCheckContainer.appendChild(countrySwitch);

    // Switch pour la vérification des proxies
    const proxyCheckContainer = document.createElement("div");
    proxyCheckContainer.style.display = "flex";
    proxyCheckContainer.style.alignItems = "center";
    proxyCheckContainer.style.justifyContent = "space-between";

    const proxyLabel = document.createElement("span");
    proxyLabel.textContent = "check proxies";
    proxyLabel.style.color = "#ff0000";

    const proxySwitch = document.createElement("label");
    proxySwitch.className = "switch";
    proxySwitch.innerHTML = `
        <input type="checkbox" id="proxyCheck">
        <span class="slider"></span>
    `;
    proxyCheckContainer.appendChild(proxyLabel);
    proxyCheckContainer.appendChild(proxySwitch);

    // Ajouter les containers au switchesContainer
    switchesContainer.appendChild(countryCheckContainer);
    switchesContainer.appendChild(proxyCheckContainer);

    // Input pour ajouter un pays
    const inputContainer = document.createElement("div");
    inputContainer.style.marginBottom = "20px";
    inputContainer.style.display = "flex";
    inputContainer.style.gap = "10px";

    const input = document.createElement("input");
    input.type = "text";
    input.placeholder = "Code pays (ex: fr, be, ch)";
    input.style.flex = "1";
    input.style.padding = "10px";
    input.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
    input.style.border = "1px solid #ff0000";
    input.style.borderRadius = "5px";
    input.style.color = "#ff0000";
    input.style.outline = "none";

    const addButton = document.createElement("button");
    addButton.textContent = "Ajouter";
    addButton.className = "menu-btn";
    addButton.onclick = () => {
        const countryCode = input.value.trim().toLowerCase();
        if (!countryCode) return;

        if (allowedCountries.has(countryCode)) {
            showNotification(`Le pays ${countryCode.toUpperCase()} est déjà dans la liste ❌`, "error");
            return;
        }
        
        fetch('countryallowed/update-countries.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ 
                action: 'add',
                countryCode: countryCode 
            })
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Erreur réseau');
            }
            return response.json();
        })
        .then(data => {
            if (data.status === 'success') {
                allowedCountries.add(countryCode);
                input.value = '';
                updateCountriesListDisplay(countriesList);
                showNotification(`Pays ${countryCode.toUpperCase()} ajouté avec succès ✅`);
            } else {
                throw new Error(data.message || 'Erreur lors de l\'ajout du pays');
            }
        })
        .catch(error => {
            loadExistingCountries().then(() => {
                updateCountriesListDisplay(countriesList);
            });
            showNotification("Erreur lors de l'ajout du pays ❌", "error");
        });
    };

    inputContainer.appendChild(input);
    inputContainer.appendChild(addButton);

    // Ajouter les éléments dans l'ordre
    container.appendChild(switchesContainer);
    container.appendChild(inputContainer);

    // Liste des pays
    const countriesList = document.createElement("div");
    countriesList.style.maxHeight = "300px";
    countriesList.style.overflowY = "auto";
    countriesList.style.marginTop = "20px";
    countriesList.style.scrollbarWidth = "thin";
    countriesList.style.scrollbarColor = "#ff0000 #1a1a1a";

    container.appendChild(countriesList);
    document.body.appendChild(container);

    // Ajouter les événements pour les switches
    countrySwitch.querySelector('input').addEventListener('change', function() {
        const isEnabled = this.checked;
        fetch('settings/update-settings.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                setting: 'country_check',
                value: isEnabled
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                showNotification(`Vérification des pays ${isEnabled ? 'activée' : 'désactivée'} ✅`);
            }
        })
        .catch(() => {
            showNotification("Erreur lors de la mise à jour des paramètres ❌", "error");
        });
    });

    proxySwitch.querySelector('input').addEventListener('change', function() {
        const isEnabled = this.checked;
        fetch('settings/update-settings.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                setting: 'proxy_check',
                value: isEnabled
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                showNotification(`Vérification des proxies ${isEnabled ? 'activée' : 'désactivée'} ✅`);
            }
        })
        .catch(() => {
            showNotification("Erreur lors de la mise à jour des paramètres ❌", "error");
        });
    });

    // Charger l'état initial des switches
    fetch('settings/get-settings.php')
        .then(response => response.json())
        .then(data => {
            countrySwitch.querySelector('input').checked = data.country_check;
            proxySwitch.querySelector('input').checked = data.proxy_check;
        })
        .catch(() => {
            showNotification("Erreur lors du chargement des paramètres ❌", "error");
        });

    // Charger et afficher les pays
    fetch('countryallowed/get-countries.php')
        .then(response => response.json())
        .then(data => {
            if (data.countries) {
                allowedCountries = new Set(data.countries);
                updateCountriesListDisplay(countriesList);
            }
        })
        .catch(error => {
            showNotification("Erreur lors du chargement des pays ❌", "error");
        });
}
    const countriesList = document.createElement("div");
    countriesList.style.maxHeight = "300px";
    countriesList.style.overflowY = "auto";
    countriesList.style.marginTop = "20px";
    countriesList.style.scrollbarWidth = "thin";
    countriesList.style.scrollbarColor = "#ff0000 #1a1a1a";

    container.appendChild(countriesList);
    document.body.appendChild(container);

    // AJOUTEZ LA FONCTION ICI
    function updateCountriesListDisplay(container) {
        container.innerHTML = '';
        
        // Mapping des codes pays vers les emojis drapeaux
        const countryFlags = {
            'fr': '🇫🇷',
            'be': '🇧🇪',
            'ch': '🇨🇭',
            'ar': '🇦🇷',
            'de': '🇩🇪',
            'ma': '🇲🇦',
            'tn': '🇹🇳',
            'dz': '🇩🇿',
            'us': '🇺🇸',
            'gb': '🇬🇧',
            'es': '🇪🇸',
            'it': '🇮🇹',
            'pt': '🇵🇹',
            'nl': '🇳🇱',
            'lu': '🇱🇺'
        };

        allowedCountries.forEach(country => {
            const countryItem = document.createElement("div");
            countryItem.style.display = "flex";
            countryItem.style.justifyContent = "space-between";
            countryItem.style.alignItems = "center";
            countryItem.style.padding = "10px";
            countryItem.style.borderBottom = "1px solid rgba(255, 0, 0, 0.3)";
            countryItem.style.color = "#ff0000";
            countryItem.style.marginBottom = "5px";

            const countryInfo = document.createElement("div");
            countryInfo.style.display = "flex";
            countryInfo.style.alignItems = "center";
            countryInfo.style.gap = "10px";

            const flag = document.createElement("span");
            flag.textContent = countryFlags[country.toLowerCase()] || '🏳️';
            flag.style.fontSize = "20px";

            const countryCode = document.createElement("span");
            countryCode.textContent = country.toUpperCase();
            countryCode.style.fontWeight = "bold";

            countryInfo.appendChild(flag);
            countryInfo.appendChild(countryCode);

            const removeButton = document.createElement("button");
            removeButton.innerHTML = "✕";
            removeButton.style.backgroundColor = "transparent";
            removeButton.style.border = "none";
            removeButton.style.color = "#ff0000";
            removeButton.style.cursor = "pointer";
            removeButton.style.padding = "5px 10px";
            removeButton.style.fontSize = "16px";
            removeButton.style.transition = "all 0.3s ease";

            removeButton.onmouseover = () => {
                removeButton.style.transform = "scale(1.1)";
                removeButton.style.color = "#ff3333";
            };
            removeButton.onmouseout = () => {
                removeButton.style.transform = "scale(1)";
                removeButton.style.color = "#ff0000";
            };

            removeButton.onclick = () => {
                fetch('countryallowed/update-countries.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ 
                        action: 'remove',
                        countryCode: country 
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        allowedCountries.delete(country);
                        updateCountriesListDisplay(container);
                        showNotification(`Pays ${countryFlags[country.toLowerCase()] || ''} ${country.toUpperCase()} retiré ✅`);
                    } else {
                        throw new Error(data.message);
                    }
                })
                .catch(error => {
                    showNotification("Erreur lors de la suppression du pays ❌", "error");
                });
            };

            countryItem.appendChild(countryInfo);
            countryItem.appendChild(removeButton);
            container.appendChild(countryItem);
        });
    }
</script>
<script src="../styles/js/blok.js"></script>
<script>
// Attendre que le DOM soit chargé
document.addEventListener('DOMContentLoaded', function() {
    addDeleteButtons();
    const menuContainer = document.querySelector('.menu-container');
    menuContainer.innerHTML = `
        <button class="menu-btn" onclick="showBanForm()">
            <svg viewBox="0 0 24 24">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9L16.9 18.31C15.55 19.37 13.85 20 12 20zm6.31-3.1L7.1 5.69C8.45 4.63 10.15 4 12 4c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9z"/>
            </svg>
            Ban IP
        </button>
        <button class="menu-btn" onclick="showAllowedCountries()">
            <svg viewBox="0 0 24 24">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"/>
            </svg>
            Allowed Countries
        </button>
        <button class="menu-btn" onclick="showBannedIPs()">
            <svg viewBox="0 0 24 24">
                <path d="M16 1H8C6.34 1 5 2.34 5 4v16c0 1.66 1.34 3 3 3h8c1.66 0 3-1.34 3-3V4c0-1.66-1.34-3-3-3zm-2 20h-4v-1h4v1zm3.25-3H6.75V4h10.5v14z"/>
                <path d="M12 17h2v-6h-2v6zm0-8h2V7h-2v2z"/>
            </svg>
            Show Banned IPs
        </button>
        <button class="menu-btn" onclick="clearLogs()">
            <svg viewBox="0 0 24 24">
                <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"/>
            </svg>
            Clear Logs
        </button>
        <button class="menu-btn" onclick="toggleIframe()">
            <svg viewBox="0 0 24 24">
                <path d="M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z"/>
            </svg>
            Status en temps réel
        </button>
    `;

    // Remplacer le bouton de fermeture
    const closeButton = document.querySelector('.close-menu');
    closeButton.innerHTML = `
        <svg viewBox="0 0 24 24">
            <path d="M18 6L6 18M6 6l12 12"/>
        </svg>
    `;
});
// delete logs
function addDeleteButtons() {
    const rows = document.querySelectorAll('#visitorTable tbody tr');
    rows.forEach(row => {
        const actionCell = document.createElement('td');
        actionCell.innerHTML = `
            <button class="delete-log-btn" onclick="deleteSpecificLog(this.parentElement.parentElement)">
                <svg class="delete-icon" viewBox="0 0 24 24" width="24" height="24">
                    <path d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" 
                          stroke="#ff0000" 
                          stroke-width="2" 
                          stroke-linecap="round" 
                          stroke-linejoin="round"
                          fill="none"/>
                </svg>
            </button>
        `;
        row.appendChild(actionCell);
    });
}
function deleteSpecificLog(row) {
    const ip = row.querySelector('td:first-child').textContent.trim().split(' ').pop();
    const date = row.querySelector('td:nth-child(2)').textContent.trim();

    if (confirm(`Voulez-vous vraiment supprimer ce log ?\nIP: ${ip}\nDate: ${date}`)) {
        // Effet de flash initial
        row.style.transition = 'background-color 0.2s';
        row.style.backgroundColor = 'rgba(255, 0, 0, 0.05)';
        
        setTimeout(() => {
            row.style.backgroundColor = '';
            row.classList.add('slice-delete');
            
            fetch('status/delete-specific-lo<tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 10:47:53</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 10:48:06</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 10:50:00</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 10:50:22</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 10:50:56</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 11:11:42</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 11:20:52</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 11:31:45</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:39:53</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:40:25</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:40:29</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:44:25</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:44:40</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:46:40</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:46:42</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:47:24</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 18:48:30</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 19:39:30</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 19:39:59</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 19:46:19</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 19:46:36</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.5</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.118.49.13</td><td>2026-01-30 19:46:58</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 144.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/gb.png' alt='United Kingdom'> 149.154.161.221</td><td>2026-01-30 19:47:13</td><td>Telegram Messenger San Francisco Network</td><td>United Kingdom</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-blocked'>🚫 PAYS NON AUTORISÉ</span></td><td>unknown</td><td>unknown unknown</td></tr>